/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.init;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.jboss.logging.Logger;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Role;
import org.jboss.seam.annotations.Roles;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Actor;
import org.jboss.seam.core.ApplicationContext;
import org.jboss.seam.core.BusinessProcessContext;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.core.ConversationContext;
import org.jboss.seam.core.ConversationList;
import org.jboss.seam.core.ConversationStack;
import org.jboss.seam.core.EventContext;
import org.jboss.seam.core.FacesContext;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.ManagedHibernateSession;
import org.jboss.seam.core.ManagedJbpmContext;
import org.jboss.seam.core.ManagedPersistenceContext;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.Pageflow;
import org.jboss.seam.core.Pages;
import org.jboss.seam.core.PooledTask;
import org.jboss.seam.core.PooledTaskInstanceList;
import org.jboss.seam.core.Process;
import org.jboss.seam.core.ProcessInstance;
import org.jboss.seam.core.ResourceBundle;
import org.jboss.seam.core.SessionContext;
import org.jboss.seam.core.StatelessContext;
import org.jboss.seam.core.Switcher;
import org.jboss.seam.core.TaskInstance;
import org.jboss.seam.core.TaskInstanceList;
import org.jboss.seam.core.TaskInstanceListForType;
import org.jboss.seam.core.Transition;
import org.jboss.seam.debug.Introspector;
import org.jboss.seam.deployment.Scanner;
import org.jboss.seam.util.NamingHelper;
import org.jboss.seam.util.Reflections;
import org.jboss.seam.util.Resources;

public class Initialization {
    private static final Logger log = Logger.getLogger(Initialization.class);
    private Map<String, String> properties = new HashMap<String, String>();
    private ServletContext servletContext;
    private boolean isScannerEnabled = true;

    public Initialization(ServletContext externalContext) {
        this.servletContext = externalContext;
        this.initPropertiesFromServletContext();
        this.initPropertiesFromResource();
    }

    public Initialization setProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public Initialization init() {
        log.info((Object)"initializing Seam");
        Lifecycle.beginInitialization(this.servletContext);
        Contexts.getApplicationContext().set("org.jboss.seam.properties", this.properties);
        this.addComponents();
        Lifecycle.endInitialization();
        log.info((Object)"done initializing Seam");
        return this;
    }

    private void initPropertiesFromServletContext() {
        Enumeration params = this.servletContext.getInitParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            this.properties.put(name, this.servletContext.getInitParameter(name));
        }
    }

    private void initPropertiesFromResource() {
        Initialization.loadFromResource(this.properties, "/seam.properties");
        Properties jndiProperties = new Properties();
        Initialization.loadFromResource(jndiProperties, "/seam-jndi.properties");
        NamingHelper.setInitialContextProperties(jndiProperties);
    }

    public static void loadFromResource(Map properties, String resource) {
        InputStream stream = Resources.getResourceAsStream(resource);
        if (stream != null) {
            log.info((Object)("reading properties from: " + resource));
            Properties props = new Properties();
            try {
                props.load(stream);
            }
            catch (IOException ioe) {
                log.error((Object)("could not read " + resource), (Throwable)ioe);
            }
            properties.putAll(props);
        } else {
            log.debug((Object)("not found: " + resource));
        }
    }

    protected void addComponents() {
        Context context = Contexts.getApplicationContext();
        this.addComponent(Init.class, context);
        this.addComponent(Pages.class, context);
        this.addComponent(Manager.class, context);
        this.addComponent(Switcher.class, context);
        this.addComponent(Conversation.class, context);
        this.addComponent(ConversationList.class, context);
        this.addComponent(ConversationStack.class, context);
        this.addComponent(FacesContext.class, context);
        this.addComponent(EventContext.class, context);
        this.addComponent(SessionContext.class, context);
        this.addComponent(StatelessContext.class, context);
        this.addComponent(ApplicationContext.class, context);
        this.addComponent(ConversationContext.class, context);
        this.addComponent(BusinessProcessContext.class, context);
        this.addComponent(ResourceBundle.class, context);
        this.addComponent(Introspector.class, context);
        this.addComponent(org.jboss.seam.debug.Contexts.class, context);
        Init init = (Init)Component.getInstance(Init.class, true);
        for (String className : init.getComponentClasses()) {
            try {
                Role[] roles;
                Class componentClass = Reflections.classForName(className);
                this.addComponent(componentClass, context);
                if (componentClass.isAnnotationPresent(Role.class)) {
                    Role role = componentClass.getAnnotation(Role.class);
                    ScopeType scope = Seam.getComponentRoleScope(componentClass, role);
                    this.addComponent(role.name(), scope, componentClass, context);
                }
                if (!componentClass.isAnnotationPresent(Roles.class)) continue;
                for (Role role : roles = componentClass.getAnnotation(Roles.class).value()) {
                    ScopeType scope = Seam.getComponentRoleScope(componentClass, role);
                    this.addComponent(role.name(), scope, componentClass, context);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("Component class not found: " + className, cnfe);
            }
        }
        for (String unitName : init.getManagedPersistenceContexts()) {
            this.addComponent(unitName, ManagedPersistenceContext.class, context);
        }
        for (String sfName : init.getManagedSessions()) {
            this.addComponent(sfName, ManagedHibernateSession.class, context);
        }
        if (init.isJbpmInstalled()) {
            this.addComponent(Actor.class, context);
            this.addComponent(Process.class, context);
            this.addComponent(Pageflow.class, context);
            this.addComponent(Transition.class, context);
            this.addComponent(PooledTask.class, context);
            this.addComponent(TaskInstance.class, context);
            this.addComponent(ProcessInstance.class, context);
            this.addComponent(TaskInstanceList.class, context);
            this.addComponent(PooledTaskInstanceList.class, context);
            this.addComponent(TaskInstanceListForType.class, context);
            this.addComponent(ManagedJbpmContext.class, context);
        }
        if (this.isScannerEnabled) {
            for (Class<?> clazz : new Scanner().getClasses()) {
                if (!clazz.isAnnotationPresent(Name.class)) continue;
                this.addComponent(clazz, context);
            }
        }
    }

    protected void addComponent(String name, ScopeType scope, Class clazz, Context context) {
        context.set(name + ".component", new Component(clazz, name, scope));
    }

    protected void addComponent(String name, Class clazz, Context context) {
        context.set(name + ".component", new Component(clazz, name));
    }

    protected void addComponent(Class clazz, Context context) {
        context.set(Seam.getComponentName(clazz) + ".component", new Component(clazz));
    }

    public boolean isScannerEnabled() {
        return this.isScannerEnabled;
    }

    public Initialization setScannerEnabled(boolean isScannerEnabled) {
        this.isScannerEnabled = isScannerEnabled;
        return this;
    }
}

