/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.util.Map;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Manager;
import org.jboss.seam.jbpm.Page;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="org.jboss.seam.core.pageflow")
@Intercept(value=InterceptionType.NEVER)
public class Pageflow {
    private int counter;
    private ProcessInstance processInstance;

    public boolean isInProcess() {
        return this.processInstance != null;
    }

    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    public static Pageflow instance() {
        if (!Contexts.isConversationContextActive()) {
            throw new IllegalStateException("No active conversation context");
        }
        return (Pageflow)Component.getInstance(Pageflow.class, ScopeType.CONVERSATION, true);
    }

    public int getPageflowCounter() {
        return this.counter;
    }

    public void validatePageflow(Map attributes) {
        Integer counter;
        if (this.processInstance != null && (counter = (Integer)attributes.get(Manager.PAGEFLOW_COUNTER)) != null && this.getPageflowCounter() != counter.intValue()) {
            FacesContext context = FacesContext.getCurrentInstance();
            this.navigate(context);
            context.renderResponse();
        }
    }

    public Page getPage() {
        if (this.processInstance == null) {
            return null;
        }
        Token pageFlowToken = this.processInstance.getRootToken();
        Page page = (Page)pageFlowToken.getNode();
        return page;
    }

    private void navigate(FacesContext context) {
        Page page = this.getPage();
        if (!page.isRedirect()) {
            UIViewRoot viewRoot = context.getApplication().getViewHandler().createView(context, page.getViewId());
            context.setViewRoot(viewRoot);
        } else {
            Manager.instance().redirect(page.getViewId());
        }
        ++this.counter;
    }

    public boolean hasDefaultTransition() {
        return this.getPage().getDefaultLeavingTransition() != null;
    }

    public boolean hasTransition(String outcome) {
        return outcome == null ? this.hasDefaultTransition() : this.getPage().getLeavingTransition(outcome) != null;
    }

    public void navigate(FacesContext context, String outcome) {
        if (outcome == null || "".equals(outcome)) {
            if (this.hasDefaultTransition()) {
                this.processInstance.signal();
                this.navigate(context);
            }
        } else {
            this.processInstance.signal(outcome);
            this.navigate(context);
        }
    }
}

