/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Jbpm;
import org.jboss.seam.core.ProcessInstance;
import org.jbpm.JbpmContext;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;

@Scope(value=ScopeType.EVENT)
@Name(value="jbpmContext")
@Intercept(value=InterceptionType.NEVER)
public class ManagedJbpmContext {
    private static final Logger log = Logger.getLogger(ManagedJbpmContext.class);
    private JbpmContext jbpmContext;

    @Create
    public void create() throws NamingException {
        this.jbpmContext = Jbpm.instance().getJbpmConfiguration().createJbpmContext();
        log.debug((Object)"created seam managed jBPM context");
    }

    @Unwrap
    public JbpmContext getJbpmContext() {
        return this.jbpmContext;
    }

    @Destroy
    public void destroy() {
        if (Lifecycle.isException()) {
            DbPersistenceServiceFactory dpsf = (DbPersistenceServiceFactory)this.jbpmContext.getJbpmConfiguration().getServiceFactory("persistence");
            if (dpsf.isTransactionEnabled()) {
                this.jbpmContext.setRollbackOnly();
            }
        } else {
            org.jbpm.graph.exe.ProcessInstance processInstance = ProcessInstance.instance();
            if (processInstance != null) {
                this.jbpmContext.save(processInstance);
            }
        }
        log.debug((Object)"destroying seam managed jBPM context");
        this.jbpmContext.close();
    }

    public static JbpmContext instance() {
        if (!Contexts.isEventContextActive()) {
            throw new IllegalStateException("no active event context");
        }
        return (JbpmContext)Component.getInstance(ManagedJbpmContext.class, ScopeType.EVENT, true);
    }
}

