/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.ProcessInstance;
import org.jbpm.context.exe.ContextInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusinessProcessContext
implements Context {
    private static final Logger log = Logger.getLogger(BusinessProcessContext.class);
    private final Map<String, Object> additions = new HashMap<String, Object>();
    private final Set<String> removals = new HashSet<String>();

    @Override
    public ScopeType getType() {
        return ScopeType.BUSINESS_PROCESS;
    }

    private ContextInstance getContextInstance() {
        org.jbpm.graph.exe.ProcessInstance processInstance = this.getProcessInstance();
        return processInstance == null ? null : processInstance.getContextInstance();
    }

    @Override
    public Object get(String name) {
        Object result = this.additions.get(name);
        if (result != null) {
            return result;
        }
        if (this.removals.contains(name)) {
            return null;
        }
        ContextInstance context = this.getContextInstance();
        return context == null ? null : context.getVariable(name);
    }

    @Override
    public void set(String name, Object value) {
        if (value == null) {
            this.remove(name);
        } else {
            this.removals.remove(name);
            this.additions.put(name, value);
        }
    }

    @Override
    public boolean isSet(String name) {
        return this.get(name) != null;
    }

    @Override
    public void remove(String name) {
        this.additions.remove(name);
        this.removals.add(name);
    }

    @Override
    public String[] getNames() {
        Set<String> results = this.getNamesFromContext();
        results.addAll(this.additions.keySet());
        return results.toArray(new String[0]);
    }

    private Set<String> getNamesFromContext() {
        HashSet<String> results = new HashSet<String>();
        ContextInstance context = this.getContextInstance();
        if (context != null) {
            results.addAll(context.getVariables().keySet());
            results.removeAll(this.removals);
        }
        return results;
    }

    @Override
    public Object get(Class clazz) {
        return this.get(Seam.getComponentName(clazz));
    }

    public void clear() {
        this.additions.clear();
        this.removals.addAll(this.getNamesFromContext());
    }

    @Override
    public void flush() {
        org.jbpm.graph.exe.ProcessInstance processInstance = this.getProcessInstance();
        if (processInstance == null) {
            log.debug((Object)"no process instance to persist business process state");
        } else if (!this.additions.isEmpty() || !this.removals.isEmpty()) {
            log.debug((Object)("flushing to process instance: " + processInstance.getId()));
            ContextInstance contextInstance = processInstance.getContextInstance();
            for (Map.Entry<String, Object> entry : this.additions.entrySet()) {
                contextInstance.setVariable(entry.getKey(), entry.getValue());
            }
            this.additions.clear();
            for (String name : this.removals) {
                contextInstance.deleteVariable(name);
            }
            this.removals.clear();
        }
    }

    private org.jbpm.graph.exe.ProcessInstance getProcessInstance() {
        Init init = Init.instance();
        if (init == null || !init.isJbpmInstalled()) {
            return null;
        }
        return ProcessInstance.instance();
    }
}

