/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Interceptors;
import javax.ejb.Local;
import javax.ejb.Remove;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import org.hibernate.validator.ClassValidator;
import org.jboss.logging.Logger;
import org.jboss.seam.ComponentType;
import org.jboss.seam.InstantiationException;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.RequiredException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Around;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.IfInvalid;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.JndiName;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.RequestParameter;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.Within;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.datamodel.DataModelSelection;
import org.jboss.seam.annotations.datamodel.DataModelSelectionIndex;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.ResourceBundle;
import org.jboss.seam.interceptors.BijectionInterceptor;
import org.jboss.seam.interceptors.BusinessProcessInterceptor;
import org.jboss.seam.interceptors.ConversationInterceptor;
import org.jboss.seam.interceptors.Interceptor;
import org.jboss.seam.interceptors.JavaBeanInterceptor;
import org.jboss.seam.interceptors.OutcomeInterceptor;
import org.jboss.seam.interceptors.RemoveInterceptor;
import org.jboss.seam.interceptors.RollbackInterceptor;
import org.jboss.seam.interceptors.ValidationInterceptor;
import org.jboss.seam.jsf.ListDataModel;
import org.jboss.seam.util.NamingHelper;
import org.jboss.seam.util.Reflections;
import org.jboss.seam.util.Sorter;
import org.jboss.seam.util.StringArrayPropertyEditor;
import org.jboss.seam.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
public class Component {
    public static final String PROPERTIES = "org.jboss.seam.properties";
    private static final Logger log = Logger.getLogger(Component.class);
    private ComponentType type;
    private String name;
    private ScopeType scope;
    private Class<?> beanClass;
    private String jndiName;
    private InterceptionType interceptionType;
    private boolean startup;
    private String[] dependencies;
    private Method destroyMethod;
    private Method createMethod;
    private Method unwrapMethod;
    private Set<Method> removeMethods;
    private Set<Method> validateMethods;
    private Set<Method> inMethods;
    private Set<Field> inFields;
    private Set<Method> outMethods;
    private Set<Field> outFields;
    private Set<Field> parameterFields;
    private Set<Method> parameterSetters;
    private Map<Method, Object> initializers;
    private List<Method> dataModelGetters;
    private Map<String, Method> dataModelSelectionIndexSetters;
    private Map<String, Method> dataModelSelectionSetters;
    private List<Field> dataModelFields;
    private Map<String, Field> dataModelSelectionIndexFields;
    private Map<String, Field> dataModelSelectionFields;
    private ClassValidator validator;
    private List<Interceptor> interceptors;
    private Set<Class> localInterfaces;
    private Class<net.sf.cglib.proxy.Factory> factory;

    public Component(Class<?> clazz) {
        this(clazz, Seam.getComponentName(clazz));
    }

    public Component(Class<?> clazz, String componentName) {
        this(clazz, componentName, Seam.getComponentScope(clazz));
    }

    public Component(Class<?> clazz, String componentName, ScopeType componentScope) {
        this(clazz, componentName, componentScope, Contexts.getApplicationContext());
    }

    public Component(Class<?> clazz, Context applicationContext) {
        this(clazz, Seam.getComponentName(clazz), Seam.getComponentScope(clazz), applicationContext);
    }

    public Component(Class<?> clazz, String componentName, ScopeType componentScope, Context applicationContext) {
        PropertyEditorManager.registerEditor(String[].class, StringArrayPropertyEditor.class);
        this.removeMethods = new HashSet<Method>();
        this.validateMethods = new HashSet<Method>();
        this.inMethods = new HashSet<Method>();
        this.inFields = new HashSet<Field>();
        this.outMethods = new HashSet<Method>();
        this.outFields = new HashSet<Field>();
        this.parameterFields = new HashSet<Field>();
        this.parameterSetters = new HashSet<Method>();
        this.initializers = new HashMap<Method, Object>();
        this.dataModelGetters = new ArrayList<Method>();
        this.dataModelSelectionIndexSetters = new HashMap<String, Method>();
        this.dataModelSelectionSetters = new HashMap<String, Method>();
        this.dataModelFields = new ArrayList<Field>();
        this.dataModelSelectionIndexFields = new HashMap<String, Field>();
        this.dataModelSelectionFields = new HashMap<String, Field>();
        this.interceptors = new ArrayList<Interceptor>();
        this.beanClass = clazz;
        this.name = componentName;
        this.scope = componentScope;
        this.type = Seam.getComponentType(this.beanClass);
        this.interceptionType = Seam.getInterceptionType(this.beanClass);
        this.checkScopeForComponentType();
        this.startup = this.beanClass.isAnnotationPresent(Startup.class);
        if (this.startup) {
            this.dependencies = this.getBeanClass().getAnnotation(Startup.class).depends();
        }
        this.jndiName = this.getJndiName(applicationContext);
        log.info((Object)("Component: " + this.getName() + ", scope: " + (Object)((Object)this.getScope()) + ", type: " + (Object)((Object)this.getType()) + ", class: " + this.beanClass.getName() + (this.jndiName == null ? "" : ", JNDI: " + this.jndiName)));
        this.initMembers(clazz, applicationContext);
        this.localInterfaces = Component.getLocalInterfaces(this.beanClass);
        if (this.interceptionType != InterceptionType.NEVER) {
            this.initInterceptors();
        }
        this.initValidator();
        this.initInitializers(applicationContext);
        if (this.type == ComponentType.JAVA_BEAN) {
            this.factory = this.createProxyFactory();
        }
    }

    private void checkScopeForComponentType() {
        if (this.scope == ScopeType.STATELESS && (this.type == ComponentType.STATEFUL_SESSION_BEAN || this.type == ComponentType.ENTITY_BEAN)) {
            throw new IllegalArgumentException("Only stateless session beans and Java beans may be bound to the STATELESS context: " + this.name);
        }
        if (this.scope == ScopeType.PAGE && this.type == ComponentType.STATEFUL_SESSION_BEAN) {
            throw new IllegalArgumentException("Stateful session beans may not be bound to the PAGE context: " + this.name);
        }
    }

    private void initValidator() {
        if (this.interceptionType != InterceptionType.NEVER) {
            java.util.ResourceBundle messages = Contexts.isApplicationContextActive() ? ResourceBundle.instance() : null;
            this.validator = messages == null ? new ClassValidator(this.beanClass) : new ClassValidator(this.beanClass, messages);
        }
    }

    private String getJndiName(Context applicationContext) {
        if (this.beanClass.isAnnotationPresent(JndiName.class)) {
            return this.beanClass.getAnnotation(JndiName.class).value();
        }
        switch (this.type) {
            case ENTITY_BEAN: 
            case JAVA_BEAN: {
                return null;
            }
        }
        if (applicationContext == null) {
            return null;
        }
        String jndiPattern = Init.instance().getJndiPattern();
        if (jndiPattern == null) {
            throw new IllegalArgumentException("You must specify org.jboss.seam.core.init.jndiPattern or use @JndiName: " + this.name);
        }
        return jndiPattern.replace("#{ejbName}", Seam.getEjbName(this.beanClass));
    }

    private void initInitializers(Context applicationContext) {
        if (applicationContext == null) {
            return;
        }
        Map properties = (Map)applicationContext.get(PROPERTIES);
        if (properties == null) {
            return;
        }
        for (Map.Entry me : properties.entrySet()) {
            PropertyDescriptor propertyDescriptor;
            String key = (String)me.getKey();
            String value = (String)me.getValue();
            if (!key.startsWith(this.name) || key.charAt(this.name.length()) != '.') continue;
            String propertyName = key.substring(this.name.length() + 1, key.length());
            try {
                propertyDescriptor = new PropertyDescriptor(propertyName, this.beanClass);
            }
            catch (IntrospectionException ie) {
                throw new IllegalArgumentException(ie);
            }
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(propertyDescriptor.getPropertyType());
            propertyEditor.setAsText(value);
            this.initializers.put(propertyDescriptor.getWriteMethod(), propertyEditor.getValue());
            log.debug((Object)(key + "=" + value));
        }
    }

    private void initMembers(Class<?> clazz, Context applicationContext) {
        AccessibleObject existing;
        String name;
        ArrayList<Method> selectionSetters = new ArrayList<Method>();
        ArrayList<Method> selectionIndexSetters = new ArrayList<Method>();
        ArrayList<AccessibleObject> selectionFields = new ArrayList<AccessibleObject>();
        ArrayList<AccessibleObject> selectionIndexFields = new ArrayList<AccessibleObject>();
        while (clazz != Object.class) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.isAnnotationPresent(IfInvalid.class)) {
                    this.validateMethods.add(method);
                }
                if (method.isAnnotationPresent(Remove.class)) {
                    this.removeMethods.add(method);
                }
                if (method.isAnnotationPresent(Destroy.class)) {
                    this.destroyMethod = method;
                }
                if (method.isAnnotationPresent(Create.class)) {
                    this.createMethod = method;
                }
                if (method.isAnnotationPresent(In.class)) {
                    this.inMethods.add(method);
                }
                if (method.isAnnotationPresent(Out.class)) {
                    this.outMethods.add(method);
                }
                if (method.isAnnotationPresent(Unwrap.class)) {
                    this.unwrapMethod = method;
                }
                if (method.isAnnotationPresent(DataModel.class)) {
                    this.checkDataModelScope(method.getAnnotation(DataModel.class));
                    this.dataModelGetters.add(method);
                }
                if (method.isAnnotationPresent(Factory.class)) {
                    Init init = (Init)applicationContext.get(Seam.getComponentName(Init.class));
                    init.addFactoryMethod(method.getAnnotation(Factory.class).value(), method, this);
                }
                if (method.isAnnotationPresent(DataModelSelectionIndex.class)) {
                    selectionIndexSetters.add(method);
                }
                if (method.isAnnotationPresent(DataModelSelection.class)) {
                    selectionSetters.add(method);
                }
                if (method.isAnnotationPresent(RequestParameter.class)) {
                    this.parameterSetters.add(method);
                }
                if (method.isAccessible()) continue;
                method.setAccessible(true);
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                if (accessibleObject.isAnnotationPresent(In.class)) {
                    this.inFields.add((Field)accessibleObject);
                }
                if (accessibleObject.isAnnotationPresent(Out.class)) {
                    this.outFields.add((Field)accessibleObject);
                }
                if (accessibleObject.isAnnotationPresent(DataModel.class)) {
                    this.checkDataModelScope(((Field)accessibleObject).getAnnotation(DataModel.class));
                    this.dataModelFields.add((Field)accessibleObject);
                }
                if (accessibleObject.isAnnotationPresent(DataModelSelection.class)) {
                    selectionFields.add(accessibleObject);
                }
                if (accessibleObject.isAnnotationPresent(DataModelSelectionIndex.class)) {
                    selectionIndexFields.add(accessibleObject);
                }
                if (accessibleObject.isAnnotationPresent(RequestParameter.class)) {
                    this.parameterFields.add((Field)accessibleObject);
                }
                if (accessibleObject.isAccessible()) continue;
                ((Field)accessibleObject).setAccessible(true);
            }
            clazz = clazz.getSuperclass();
        }
        boolean hasMultipleDataModels = this.dataModelGetters.size() + this.dataModelFields.size() > 1;
        String defaultDataModelName = null;
        if (!hasMultipleDataModels) {
            if (!this.dataModelGetters.isEmpty()) {
                Method dataModelGetter = this.dataModelGetters.get(0);
                defaultDataModelName = Component.toName(dataModelGetter.getAnnotation(DataModel.class).value(), dataModelGetter);
            } else if (!this.dataModelFields.isEmpty()) {
                Field dataModelField = this.dataModelFields.get(0);
                defaultDataModelName = Component.toName(dataModelField.getAnnotation(DataModel.class).value(), dataModelField);
            }
        }
        for (Method method : selectionSetters) {
            name = method.getAnnotation(DataModelSelection.class).value();
            if (name.length() == 0) {
                if (hasMultipleDataModels) {
                    throw new IllegalStateException("Missing value() for @DataModelSelection with multiple @DataModels");
                }
                name = defaultDataModelName;
            }
            if ((existing = this.dataModelSelectionSetters.put(name, method)) == null) continue;
            throw new IllegalStateException("Multiple @DataModelSelection setters for: " + name);
        }
        for (Field field : selectionFields) {
            name = field.getAnnotation(DataModelSelection.class).value();
            if (name.length() == 0) {
                if (hasMultipleDataModels) {
                    throw new IllegalStateException("Missing value() for @DataModelSelection with multiple @DataModels");
                }
                name = defaultDataModelName;
            }
            if ((existing = this.dataModelSelectionFields.put(name, field)) == null) continue;
            throw new IllegalStateException("Multiple @DataModelSelection fields for: " + name);
        }
        for (Method method : selectionIndexSetters) {
            name = method.getAnnotation(DataModelSelectionIndex.class).value();
            if (name.length() == 0) {
                if (hasMultipleDataModels) {
                    throw new IllegalStateException("Missing value() for @DataModelSelectionIndex with multiple @DataModels");
                }
                name = defaultDataModelName;
            }
            if ((existing = this.dataModelSelectionIndexSetters.put(name, method)) == null) continue;
            throw new IllegalStateException("Multiple @DataModelSelectionIndex setters for: " + name);
        }
        for (Field field : selectionIndexFields) {
            name = field.getAnnotation(DataModelSelectionIndex.class).value();
            if (name.length() == 0) {
                if (hasMultipleDataModels) {
                    throw new IllegalStateException("Missing value() for @DataModelSelectionIndex with multiple @DataModels");
                }
                name = defaultDataModelName;
            }
            if ((existing = this.dataModelSelectionIndexFields.put(name, field)) == null) continue;
            throw new IllegalStateException("Multiple @DataModelSelectionIndex fields for: " + name);
        }
    }

    private void checkDataModelScope(DataModel dataModel) {
        ScopeType dataModelScope = dataModel.scope();
        if (dataModelScope != ScopeType.PAGE && dataModelScope != ScopeType.UNSPECIFIED) {
            throw new IllegalArgumentException("@DataModel scope must be ScopeType.UNSPECIFIED or ScopeType.PAGE: " + this.name);
        }
    }

    private void initInterceptors() {
        this.initDefaultInterceptors();
        for (Annotation annotation : this.beanClass.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Interceptors.class)) continue;
            this.interceptors.add(new Interceptor(annotation, this));
        }
        new Sorter<Interceptor>(){

            @Override
            protected boolean isOrderViolated(Interceptor outside, Interceptor inside) {
                Class<?> insideClass = inside.getUserInterceptor().getClass();
                Class<?> outsideClass = outside.getUserInterceptor().getClass();
                Around around = insideClass.getAnnotation(Around.class);
                Within within = outsideClass.getAnnotation(Within.class);
                return around != null && Arrays.asList(around.value()).contains(outsideClass) || within != null && Arrays.asList(within.value()).contains(insideClass);
            }
        }.sort(this.interceptors);
        log.trace((Object)("interceptor stack: " + this.interceptors));
    }

    private void initDefaultInterceptors() {
        this.interceptors.add(new Interceptor(new OutcomeInterceptor(), this));
        this.interceptors.add(new Interceptor(new RemoveInterceptor(), this));
        this.interceptors.add(new Interceptor(new BusinessProcessInterceptor(), this));
        this.interceptors.add(new Interceptor(new ConversationInterceptor(), this));
        this.interceptors.add(new Interceptor(new BijectionInterceptor(), this));
        this.interceptors.add(new Interceptor(new ValidationInterceptor(), this));
        this.interceptors.add(new Interceptor(new RollbackInterceptor(), this));
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public String getName() {
        return this.name;
    }

    public ComponentType getType() {
        return this.type;
    }

    public ScopeType getScope() {
        return this.scope;
    }

    public ClassValidator getValidator() {
        return this.validator;
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public Method getDestroyMethod() {
        return this.destroyMethod;
    }

    public Set<Method> getRemoveMethods() {
        return this.removeMethods;
    }

    public Set<Method> getValidateMethods() {
        return this.validateMethods;
    }

    public boolean hasDestroyMethod() {
        return this.destroyMethod != null;
    }

    public boolean hasCreateMethod() {
        return this.createMethod != null;
    }

    public Method getCreateMethod() {
        return this.createMethod;
    }

    public boolean hasUnwrapMethod() {
        return this.unwrapMethod != null;
    }

    public Method getUnwrapMethod() {
        return this.unwrapMethod;
    }

    public Set<Field> getOutFields() {
        return this.outFields;
    }

    public Set<Method> getOutMethods() {
        return this.outMethods;
    }

    public Set<Method> getInMethods() {
        return this.inMethods;
    }

    public Set<Field> getInFields() {
        return this.inFields;
    }

    public Object newInstance() {
        log.debug((Object)("instantiating Seam component: " + this.name));
        try {
            return this.initialize(this.instantiate());
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate Seam component", e);
        }
    }

    public boolean needsInjection() {
        return !this.getInFields().isEmpty() || !this.getInMethods().isEmpty() || !this.dataModelSelectionSetters.isEmpty() || !this.dataModelSelectionIndexSetters.isEmpty() || !this.dataModelSelectionFields.isEmpty() || !this.dataModelSelectionIndexFields.isEmpty() || !this.parameterFields.isEmpty() || !this.parameterSetters.isEmpty();
    }

    public boolean needsOutjection() {
        return !this.getOutFields().isEmpty() || !this.getOutMethods().isEmpty() || !this.dataModelGetters.isEmpty() || !this.dataModelFields.isEmpty();
    }

    protected Object instantiate() throws Exception {
        switch (this.type) {
            case JAVA_BEAN: {
                if (this.interceptionType == InterceptionType.NEVER) {
                    return this.beanClass.newInstance();
                }
                net.sf.cglib.proxy.Factory bean = this.factory.newInstance();
                bean.setCallback(0, (Callback)new JavaBeanInterceptor());
                return bean;
            }
            case ENTITY_BEAN: {
                return this.beanClass.newInstance();
            }
            case STATELESS_SESSION_BEAN: 
            case STATEFUL_SESSION_BEAN: {
                return NamingHelper.getInitialContext().lookup(this.jndiName);
            }
        }
        throw new IllegalStateException();
    }

    protected Object initialize(Object bean) throws Exception {
        for (Map.Entry<Method, Object> me : this.initializers.entrySet()) {
            Reflections.invoke(me.getKey(), bean, me.getValue());
        }
        return bean;
    }

    public void inject(Object bean) {
        this.injectMethods(bean);
        this.injectFields(bean);
        this.injectDataModelSelection(bean);
        this.injectParameters(bean);
    }

    private void injectParameters(Object bean) {
        String name;
        Map requestParameters = null;
        if (FacesContext.getCurrentInstance() != null) {
            requestParameters = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        } else if (Lifecycle.getServletRequest() != null) {
            requestParameters = Lifecycle.getServletRequest().getParameterMap();
        }
        for (Method setter : this.parameterSetters) {
            name = Component.toName(setter.getAnnotation(RequestParameter.class).value(), setter);
            this.setPropertyValue(bean, setter, name, requestParameters.get(name));
        }
        for (Field field : this.parameterFields) {
            name = Component.toName(field.getAnnotation(RequestParameter.class).value(), field);
            this.setFieldValue(bean, field, name, requestParameters.get(name));
        }
    }

    public void outject(Object bean) {
        this.outjectMethods(bean);
        this.outjectFields(bean);
        this.outjectDataModel(bean);
    }

    private void injectDataModelSelection(Object bean) {
        String name;
        DataModel dataModelAnn;
        for (Method method : this.dataModelGetters) {
            dataModelAnn = method.getAnnotation(DataModel.class);
            name = Component.toName(dataModelAnn.value(), method);
            this.injectDataModelSelection(bean, name, dataModelAnn.scope());
        }
        for (Field field : this.dataModelFields) {
            dataModelAnn = field.getAnnotation(DataModel.class);
            name = Component.toName(dataModelAnn.value(), field);
            this.injectDataModelSelection(bean, name, dataModelAnn.scope());
        }
    }

    private void injectDataModelSelection(Object bean, String name, ScopeType scope) {
        javax.faces.model.DataModel dataModel = (javax.faces.model.DataModel)this.getDataModelContext(scope).get(name);
        if (dataModel != null) {
            int rowIndex = dataModel.getRowIndex();
            log.debug((Object)("selected row: " + rowIndex));
            if (rowIndex > -1) {
                Field field;
                Method setter = this.dataModelSelectionIndexSetters.get(name);
                if (setter != null) {
                    this.setPropertyValue(bean, setter, name, rowIndex);
                }
                if ((field = this.dataModelSelectionIndexFields.get(name)) != null) {
                    this.setFieldValue(bean, field, name, rowIndex);
                }
                if ((setter = this.dataModelSelectionSetters.get(name)) != null) {
                    this.setPropertyValue(bean, setter, name, this.getSelectedRowData(dataModel));
                }
                if ((field = this.dataModelSelectionFields.get(name)) != null) {
                    this.setFieldValue(bean, field, name, this.getSelectedRowData(dataModel));
                }
            }
        }
    }

    private Object getSelectedRowData(javax.faces.model.DataModel dataModel) {
        return dataModel.getRowCount() == 0 || dataModel.getRowIndex() == -1 ? null : dataModel.getRowData();
    }

    private void outjectDataModel(Object bean) {
        List list;
        String name;
        DataModel dataModelAnn;
        for (Method method : this.dataModelGetters) {
            dataModelAnn = method.getAnnotation(DataModel.class);
            name = Component.toName(dataModelAnn.value(), method);
            list = (List)this.getPropertyValue(bean, method, name);
            this.outjectDataModelList(name, list, dataModelAnn.scope());
        }
        for (Field field : this.dataModelFields) {
            dataModelAnn = field.getAnnotation(DataModel.class);
            name = Component.toName(dataModelAnn.value(), field);
            list = (List)this.getFieldValue(bean, field, name);
            this.outjectDataModelList(name, list, dataModelAnn.scope());
        }
    }

    private void outjectDataModelList(String name, List list, ScopeType scope) {
        Context context = this.getDataModelContext(scope);
        javax.faces.model.DataModel existingDataModel = (javax.faces.model.DataModel)context.get(name);
        if (existingDataModel == null || !existingDataModel.getWrappedData().equals(list)) {
            if (list != null) {
                ListDataModel dataModel = new ListDataModel(list);
                context.set(name, dataModel);
            } else {
                context.remove(name);
            }
        }
    }

    private Context getDataModelContext(ScopeType specifiedScope) {
        ScopeType scope = this.scope;
        if (scope == ScopeType.STATELESS) {
            scope = ScopeType.EVENT;
        }
        if (specifiedScope != ScopeType.UNSPECIFIED) {
            scope = specifiedScope;
        }
        return scope.getContext();
    }

    private void injectMethods(Object bean) {
        for (Method method : this.getInMethods()) {
            In in = method.getAnnotation(In.class);
            String name = Component.toName(in.value(), method);
            this.setPropertyValue(bean, method, name, this.getInstanceToInject(in, name, bean));
        }
    }

    private void injectFields(Object bean) {
        for (Field field : this.getInFields()) {
            In in = field.getAnnotation(In.class);
            String name = Component.toName(in.value(), field);
            this.setFieldValue(bean, field, name, this.getInstanceToInject(in, name, bean));
        }
    }

    private void outjectFields(Object bean) {
        for (Field field : this.getOutFields()) {
            Out out = field.getAnnotation(Out.class);
            if (out == null) continue;
            String name = Component.toName(out.value(), field);
            this.setOutjectedValue(out, name, this.getFieldValue(bean, field, name));
        }
    }

    private void outjectMethods(Object bean) {
        for (Method method : this.getOutMethods()) {
            Out out = method.getAnnotation(Out.class);
            if (out == null) continue;
            String name = Component.toName(out.value(), method);
            this.setOutjectedValue(out, name, this.getPropertyValue(bean, method, name));
        }
    }

    private void setOutjectedValue(Out out, String name, Object value) {
        ScopeType scope;
        if (value == null && out.required()) {
            throw new RequiredException("Out attribute requires value for component: " + this.getAttributeMessage(name));
        }
        if (out.scope() == ScopeType.UNSPECIFIED) {
            Component component = Component.forName(name);
            if (value != null && component != null && !component.isInstance(value)) {
                throw new IllegalArgumentException("attempted to bind an Out attribute of the wrong type to: " + this.getAttributeMessage(name));
            }
            scope = component == null ? ScopeType.EVENT : component.getScope();
        } else {
            scope = out.scope();
        }
        if (value == null) {
            scope.getContext().remove(name);
        } else {
            scope.getContext().set(name, value);
        }
    }

    public boolean isInstance(Object bean) {
        switch (this.type) {
            case ENTITY_BEAN: 
            case JAVA_BEAN: {
                return this.beanClass.isInstance(bean);
            }
        }
        Class<?> clazz = bean.getClass();
        for (Class intfc : this.localInterfaces) {
            if (!intfc.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    private static Set<Class> getLocalInterfaces(Class clazz) {
        HashSet<Class> result;
        block4: {
            block3: {
                result = new HashSet<Class>();
                if (!clazz.isAnnotationPresent(Local.class)) break block3;
                Local local = clazz.getAnnotation(Local.class);
                for (Class iface : local.value()) {
                    result.add(iface);
                }
                break block4;
            }
            for (Class<?> iface : clazz.getInterfaces()) {
                if (!iface.isAnnotationPresent(Local.class)) continue;
                result.add(iface);
            }
            if (result.size() != 0) break block4;
            for (Class<?> iface : clazz.getInterfaces()) {
                if (Component.isExcludedLocalInterfaceName(iface.getName())) continue;
                result.add(iface);
            }
        }
        return result;
    }

    private static boolean isExcludedLocalInterfaceName(String name) {
        return name.equals("java.io.Serializable") || name.equals("java.io.Externalizable") || name.startsWith("javax.ejb.");
    }

    private Object getFieldValue(Object bean, Field field, String name) {
        try {
            return field.get(bean);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not outject: " + this.getAttributeMessage(name), e);
        }
    }

    private Object getPropertyValue(Object bean, Method method, String name) {
        try {
            return Reflections.invoke(method, bean, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not outject: " + this.getAttributeMessage(name), e);
        }
    }

    private void setPropertyValue(Object bean, Method method, String name, Object value) {
        try {
            Reflections.invoke(method, bean, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not inject: " + this.getAttributeMessage(name), e);
        }
    }

    private void setFieldValue(Object bean, Field field, String name, Object value) {
        try {
            field.set(bean, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not inject: " + this.getAttributeMessage(name), e);
        }
    }

    public static Component forName(String name) {
        return (Component)Contexts.getApplicationContext().get(name + ".component");
    }

    public static Object getInstance(Class<?> clazz, boolean create) {
        return Component.getInstance(Seam.getComponentName(clazz), create);
    }

    public static Object getInstance(Class<?> clazz, ScopeType scope, boolean create) {
        return Component.getInstance(Seam.getComponentName(clazz), scope, create);
    }

    public static Object getInstance(String name, boolean create) {
        Object result = Contexts.lookupInStatefulContexts(name);
        result = Component.getInstance(name, create, result);
        return result;
    }

    public static Object getInstance(String name, ScopeType scope, boolean create) {
        Object result = scope.getContext().get(name);
        result = Component.getInstance(name, create, result);
        return result;
    }

    private static Object getInstance(String name, boolean create, Object result) {
        if (result == null && create && (result = Component.getInstanceFromFactory(name)) == null) {
            result = Component.newInstance(name);
        }
        if (result != null) {
            Component component = Component.forName(name);
            if (component != null && !component.isInstance(result)) {
                throw new IllegalArgumentException("value found for In attribute has the wrong type: " + name);
            }
            result = Component.unwrap(component, result);
            if (log.isTraceEnabled()) {
                log.trace((Object)Strings.toString(result));
            }
        }
        return result;
    }

    public static Object getInstanceFromFactory(String name) {
        Init.FactoryMethod factoryMethod;
        Init init = Init.instance();
        Init.FactoryMethod factoryMethod2 = factoryMethod = init == null ? null : init.getFactory(name);
        if (factoryMethod == null) {
            return null;
        }
        Object factory = Component.getInstance(factoryMethod.component.getName(), true);
        Component.callComponentMethod(factoryMethod.component, factory, factoryMethod.method);
        return Contexts.lookupInStatefulContexts(name);
    }

    public static Object newInstance(String name) {
        Component component = Component.forName(name);
        if (component == null) {
            log.debug((Object)("seam component not found: " + name));
            return null;
        }
        Object instance = component.newInstance();
        if (component.getScope() != ScopeType.STATELESS) {
            Component.callCreateMethod(component, instance);
            component.getScope().getContext().set(name, instance);
        }
        return instance;
    }

    private static void callCreateMethod(Component component, Object instance) {
        if (component.hasCreateMethod()) {
            Component.callComponentMethod(component, instance, component.getCreateMethod());
        }
    }

    private static Object callComponentMethod(Component component, Object instance, Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        String createMethodName = method.getName();
        try {
            Method interfaceMethod = instance.getClass().getMethod(createMethodName, paramTypes);
            if (paramTypes.length == 0) {
                return Reflections.invokeAndWrap(interfaceMethod, instance, new Object[0]);
            }
            return Reflections.invokeAndWrap(interfaceMethod, instance, component);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("create method not found", e);
        }
    }

    private static Object unwrap(Component component, Object instance) {
        if (component != null && component.hasUnwrapMethod()) {
            instance = Component.callComponentMethod(component, instance, component.getUnwrapMethod());
        }
        return instance;
    }

    private Object getInstanceToInject(In in, String name, Object bean) {
        Object result;
        if (name.startsWith("#")) {
            FacesContext facesCtx = FacesContext.getCurrentInstance();
            Application application = facesCtx.getApplication();
            result = application.createValueBinding(name).getValue(facesCtx);
        } else if (in.scope() == ScopeType.UNSPECIFIED) {
            result = Component.getInstance(name, in.create());
        } else {
            if (in.create()) {
                throw new IllegalArgumentException("cannot combine create=true with explicit scope on @In: " + this.getAttributeMessage(name));
            }
            result = in.scope().getContext().get(name);
        }
        if (result == null && in.required()) {
            throw new RequiredException("In attribute requires value for component: " + this.getAttributeMessage(name));
        }
        return result;
    }

    private String getAttributeMessage(String attributeName) {
        return this.getName() + '.' + attributeName;
    }

    private static String toName(String name, Method method) {
        if (name == null || name.length() == 0) {
            name = method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
        }
        return name;
    }

    private static String toName(String name, Field field) {
        if (name == null || name.length() == 0) {
            name = field.getName();
        }
        return name;
    }

    public String toString() {
        return "Component(" + this.name + ")";
    }

    private Class<net.sf.cglib.proxy.Factory> createProxyFactory() {
        Enhancer en = new Enhancer();
        en.setUseCache(false);
        en.setInterceptDuringConstruction(false);
        en.setCallbackType(MethodInterceptor.class);
        en.setSuperclass(this.beanClass);
        return en.createClass();
    }

    public InterceptionType getInterceptionType() {
        return this.interceptionType;
    }

    public boolean isStartup() {
        return this.startup;
    }

    public String[] getDependencies() {
        return this.dependencies;
    }
}

