/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.xml;

import org.jboss.logging.Logger;
import org.jboss.util.xml.SchemaResolverFactory;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;

public class SingletonSchemaResolverFactory
implements SchemaResolverFactory {
    private static final Logger log = Logger.getLogger(SingletonSchemaResolverFactory.class);
    private static final SingletonSchemaResolverFactory singleton = new SingletonSchemaResolverFactory();
    private final DefaultSchemaResolver resolver = new DefaultSchemaResolver();

    public static SingletonSchemaResolverFactory getInstance() {
        return singleton;
    }

    private SingletonSchemaResolverFactory() {
        this.addSchema("urn:jboss:aop-deployer", "org.jboss.aspects.kernel.schema.AspectSchemaBindingInitalizer");
        this.addSchema("urn:jboss:bean-deployer", "org.jboss.kernel.plugins.deployment.xml.BeanSchemaInitializer");
        this.addSchema("urn:jboss:bean-deployer:2.0", "org.jboss.kernel.plugins.deployment.xml.BeanSchemaInitializer20");
        this.addSchema("urn:jboss:javabean:1.0", "org.jboss.kernel.plugins.config.xml.JavaBeanSchemaInitializer");
    }

    public SchemaBindingResolver getSchemaBindingResolver() {
        return this.resolver;
    }

    protected boolean addSchema(String namespace, String initializer) {
        try {
            this.resolver.addSchemaInitializer(namespace, initializer);
            log.trace("Mapped initializer '" + namespace + "' to '" + initializer + "'");
            return true;
        }
        catch (Exception ignored) {
            log.trace("Ignored: ", ignored);
            return false;
        }
    }

    protected boolean addSchema(String namespace, String initializer, String location) {
        if (!this.addSchema(namespace, initializer)) {
            return false;
        }
        this.resolver.addSchemaLocation(namespace, location);
        log.trace("Mapped location '" + namespace + "' to '" + location + "'");
        return true;
    }
}

