/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.container.modules;

import java.io.IOException;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.container.AuthException;
import javax.security.auth.container.AuthParam;
import javax.security.auth.container.MessageLayer;
import javax.security.auth.container.MessagePolicy;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.security.auth.container.modules.AbstractServerAuthModule;
import org.jboss.security.auth.login.LoginModuleStackHolder;
import org.jboss.security.auth.login.XMLLoginConfigImpl;

public class DelegatingServerAuthModule
extends AbstractServerAuthModule {
    protected static Logger log = Logger.getLogger((Class)DelegatingServerAuthModule.class);
    protected LoginContext lc = null;
    private boolean trace = log.isTraceEnabled();
    protected String configurationName = null;
    protected ObjectName securityConfigMBean = null;
    protected Subject authenticatedSubject = null;
    protected LoginModuleStackHolder loginModuleStackHolder = null;
    protected boolean testMode = false;

    public DelegatingServerAuthModule(String configName) {
        if (configName == null) {
            throw new IllegalArgumentException("Illegal Null Argument: configName");
        }
        if (this.trace) {
            log.trace((Object)("ctr:configName=" + configName));
        }
        this.configurationName = configName;
    }

    public DelegatingServerAuthModule(String configName, Configuration config) {
        this(configName);
        if (config == null) {
            throw new IllegalArgumentException("Illegal Null Argument: config");
        }
        Configuration.setConfiguration(config);
    }

    public DelegatingServerAuthModule(LoginModuleStackHolder lmsh) {
        this.loginModuleStackHolder = lmsh;
        this.configurationName = lmsh.getName();
        XMLLoginConfigImpl xmlConfig = null;
        Configuration config = Configuration.getConfiguration();
        if (config != null && config instanceof XMLLoginConfigImpl) {
            xmlConfig = (XMLLoginConfigImpl)config;
        } else {
            xmlConfig = new XMLLoginConfigImpl();
            Configuration.setConfiguration(xmlConfig);
        }
        xmlConfig.addAppConfig(lmsh.getName(), lmsh.getAppConfigurationEntry());
    }

    public void disposeSubject(Subject subject, Map sharedState) throws AuthException {
        if (this.trace) {
            log.trace((Object)"disposeSubject called");
        }
        try {
            if (this.lc != null) {
                this.lc.logout();
                if (this.trace) {
                    log.trace((Object)"disposeSubject:lc.logout success");
                }
            } else if (this.trace) {
                log.trace((Object)"disposeSubject:LoginContext is null");
            }
        }
        catch (LoginException e) {
            log.debug((Object)"disposeSubject:lc.logout throws an exception::", (Throwable)e);
            AuthException ae = new AuthException("disposeSubject failed::" + e.getLocalizedMessage());
            ae.initCause((Throwable)e);
            throw ae;
        }
    }

    public MessageLayer getMessageLayer() {
        throw new IllegalStateException("Not Implemented");
    }

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options, boolean mustBeTransactional) throws AuthException {
        super.initialize(requestPolicy, responsePolicy, handler, options, mustBeTransactional);
        if (this.trace) {
            log.trace((Object)("initialize:callbackHandler=" + handler.getClass().getName()));
        }
        if (options != null) {
            String option = (String)options.get("securityConfigService");
            try {
                if (option != null) {
                    this.securityConfigMBean = new ObjectName(option.trim());
                }
            }
            catch (MalformedObjectNameException e) {
                IllegalStateException ise = new IllegalStateException(e.getLocalizedMessage());
                ise.initCause(e);
                throw ise;
            }
            String testM = (String)options.get("testMode");
            if (testM != null) {
                this.testMode = Boolean.valueOf(testM);
            }
        }
    }

    public void secureResponse(AuthParam param, Subject source, Map sharedState) throws AuthException {
        throw new IllegalStateException("Not Implemented");
    }

    public void validateRequest(AuthParam param, Subject source, Subject recipient, Map sharedState) throws AuthException {
        if (this.trace) {
            log.trace((Object)"validateRequest called");
        }
        try {
            this.checkConfigurationPresence();
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException(e.getLocalizedMessage());
            ise.initCause(e);
            throw ise;
        }
        try {
            if (this.callbackHandler == null) {
                throw new IllegalStateException("CallbackHandler is null");
            }
            this.lc = source == null ? new LoginContext(this.configurationName, this.callbackHandler) : new LoginContext(this.configurationName, source, this.callbackHandler);
            if (this.trace) {
                Configuration cfg = Configuration.getConfiguration();
                AppConfigurationEntry[] aentries = cfg.getAppConfigurationEntry(this.configurationName);
                for (int i = 0; i < aentries.length; ++i) {
                    this.logAppConfigurationEntry(aentries[i]);
                }
            }
        }
        catch (LoginException e) {
            log.debug((Object)"validateRequest:Instantiation of LoginContext failed::", (Throwable)e);
            AuthException ae = new AuthException("validateRequest failed::" + e.getLocalizedMessage());
            ae.initCause((Throwable)e);
            throw ae;
        }
        try {
            this.lc.login();
            if (this.trace) {
                log.trace((Object)"validateRequest:lc.login() successful");
            }
            if (source == null) {
                source = this.lc.getSubject();
            }
            this.authenticatedSubject = source;
        }
        catch (LoginException e) {
            log.debug((Object)"validateRequest:lc.login throws an exception::", (Throwable)e);
            AuthException ae = new AuthException("validateRequest failed::" + e.getLocalizedMessage());
            ae.initCause((Throwable)e);
            throw ae;
        }
    }

    public Subject getAuthenticatedSubject() {
        return this.authenticatedSubject;
    }

    private void checkConfigurationPresence() throws IOException, JMException, NamingException {
        Configuration cfg = null;
        try {
            cfg = Configuration.getConfiguration();
        }
        catch (SecurityException e) {
            log.debug((Object)"Unable to obtain login configuration:", (Throwable)e);
            log.debug((Object)"Will try to obtain configuration from the securityconfig MBean");
        }
        if (cfg != null) {
            return;
        }
        cfg = this.getConfigurationFromSecurityConfigService();
        if (cfg == null) {
            throw new IllegalStateException("Configuration is not present");
        }
        Configuration.setConfiguration(cfg);
    }

    private Configuration getConfigurationFromSecurityConfigService() throws NamingException, IOException {
        MBeanServerConnection server = null;
        Configuration config = null;
        if (this.securityConfigMBean == null) {
            throw new IllegalStateException("securityConfigMBean Name is null");
        }
        if (this.testMode) {
            InitialContext ctx = new InitialContext();
            server = (MBeanServerConnection)ctx.lookup("jmx/invoker/RMIAdaptor");
        } else {
            server = MBeanServerLocator.locateJBoss();
        }
        Object[] args = new Object[]{null};
        String[] signature = new String[]{"javax.security.auth.login.Configuration"};
        try {
            String configService = (String)server.getAttribute(this.securityConfigMBean, "LoginConfig");
            config = (Configuration)server.invoke(new ObjectName(configService), "getConfiguration", args, signature);
        }
        catch (JMException e) {
            IllegalStateException ise = new IllegalStateException(e.getLocalizedMessage());
            ise.initCause(e);
            throw ise;
        }
        return config;
    }

    private void logAppConfigurationEntry(AppConfigurationEntry ae) {
        log.debug((Object)("LoginModuleName:" + ae.getLoginModuleName()));
        log.debug((Object)("Control Flag:" + ae.getControlFlag()));
    }
}

