/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.container;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.container.AuthException;
import javax.security.auth.container.AuthParam;
import javax.security.auth.container.MessageLayer;
import javax.security.auth.container.ServerAuthConfig;
import javax.security.auth.container.ServerAuthContext;
import javax.security.auth.container.ServerAuthModule;
import org.jboss.security.auth.container.WebContainerServerAuthConfig;

public class JBossServerAuthContext
implements ServerAuthContext {
    private List modules = new ArrayList();

    public JBossServerAuthContext(ServerAuthConfig config) {
        if (config instanceof WebContainerServerAuthConfig) {
            this.modules.add(((WebContainerServerAuthConfig)config).getModules());
        }
    }

    public void disposeSubject(Subject subject, Map sharedState) throws AuthException {
        int len = this.modules.size();
        for (int i = 0; i < len; ++i) {
            ServerAuthModule module = (ServerAuthModule)this.modules.get(i);
            module.disposeSubject(subject, sharedState);
        }
    }

    public MessageLayer getMessageLayer() {
        ServerAuthModule module = (ServerAuthModule)this.modules.get(0);
        return module.getMessageLayer();
    }

    public void secureResponse(AuthParam authParam, Subject source, Map sharedState) throws AuthException {
        int len = this.modules.size();
        for (int i = 0; i < len; ++i) {
            ServerAuthModule module = (ServerAuthModule)this.modules.get(i);
            module.secureResponse(authParam, source, sharedState);
        }
    }

    public void validateRequest(AuthParam authParam, Subject source, Subject recipient, Map sharedState) throws AuthException {
        int len = this.modules.size();
        for (int i = 0; i < len; ++i) {
            ServerAuthModule module = (ServerAuthModule)this.modules.get(i);
            module.validateRequest(authParam, source, recipient, sharedState);
        }
    }
}

