package com.corejsf;

import java.io.Serializable;
import java.util.Date;

import javax.faces.bean.ManagedBean; 
   // lub import javax.inject.Named;
import javax.faces.bean.SessionScoped; 
   // lub import javax.enterprise.context.SessionScoped;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;

@ManagedBean(name="payment") // lub @Named("payment")
@SessionScoped
public class PaymentBean implements Serializable {
   @Min(10) @Max(10000)
   private double amount;
   @Size(min=13,message="{com.corejsf.creditCardLength}") @LuhnCheck
   private String card = "";
   @Future
   private Date date = new Date();

   public void setAmount(double newValue) { amount = newValue; }
   public double getAmount() { return amount; }

   public void setCard(String newValue) { card = newValue; }
   public String getCard() { return card; }

   public void setDate(Date newValue) { date = newValue; }
   public Date getDate() { return date; }
}
