package com.corejsf;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.annotation.Resource;
import javax.faces.bean.ManagedBean; 
   // lub import javax.inject.Named;
import javax.faces.bean.SessionScoped; 
   // lub import javax.enterprise.context.SessionScoped;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.Message.RecipientType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

@ManagedBean // lub @Named
@SessionScoped
public class NewAccount implements Serializable {
   private String name;
   private String emailAddress;
   private String password;

   @Resource(name="mail/gmailAccount")
   private Session mailSession;

   public String getName() { return name; }
   public void setName(String newValue) { name = newValue; }

   public String getEmailAddress() { return emailAddress; }
   public void setEmailAddress(String newValue) { emailAddress = newValue; }
   
   public String create() {
      try {
         createAccount();
         sendNotification();
         return "done";
      }
      catch (Exception ex) {
         Logger.getLogger("com.corejsf").log(Level.SEVERE, "bd logowania", ex);
         return "error";
      }
   }
   
   private void createAccount() {      
      // Generuje losowe haso (8-cyfrow potg liczby 36).
      int BASE = 36;
      int LENGTH = 8;
      password = Long.toString((long)(Math.pow(BASE, LENGTH) * Math.random()), BASE);
      /*
       * W rzeczywistej aplikacji musielibymy sprawdzi, czy nazwa uytkownika jest dostpna,
       * oraz zapisa par nazwa-haso w bazie danych.
       */
   }

   private void sendNotification() throws MessagingException {
      ResourceBundle bundle = ResourceBundle.getBundle("com.corejsf.messages");
      String subject = bundle.getString("subject");
      String body = bundle.getString("body");
      String messageText = MessageFormat.format(body, name, password);
      mailSession.setDebug(true);
      MimeMessage message = new MimeMessage(mailSession);

      Address toAddress = new InternetAddress(emailAddress);
      message.setRecipient(RecipientType.TO, toAddress);
      message.setSubject(subject);
      message.setText(messageText);
      message.saveChanges();   
         
      Transport tr = mailSession.getTransport();      
      String serverPassword = mailSession.getProperty("mail.password");       
      tr.connect(null, serverPassword);
      tr.sendMessage(message, message.getAllRecipients());
      tr.close();
   }
}
