package com.devchronicles.decorator;

public abstract class Extra implements Order {
	protected Order order;
	protected String label;
	protected double price;

	public Extra(String label, double price, Order order) {
		this.label = label;
		this.price = price;
		this.order = order;
	}

	// Cena moe by problematyczna, wic oddajemy to do konkretnej implementacji.
	public abstract double getPrice();

	// Standardowy sposb oznaczania powinien wystarczy.
	public String getLabel() {
		return order.getLabel() + ", " + this.label;
	}
}