/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class FastTreeMap
extends TreeMap {
    protected TreeMap map = null;
    protected boolean fast = false;

    public FastTreeMap() {
        this.map = new TreeMap();
    }

    public FastTreeMap(Comparator comparator) {
        this.map = new TreeMap(comparator);
    }

    public FastTreeMap(Map map) {
        this.map = new TreeMap(map);
    }

    public FastTreeMap(SortedMap sortedMap) {
        this.map = new TreeMap(sortedMap);
    }

    public boolean getFast() {
        return this.fast;
    }

    public void setFast(boolean bl) {
        this.fast = bl;
    }

    public void clear() {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap treeMap = (TreeMap)this.map.clone();
                treeMap.clear();
                this.map = treeMap;
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            this.map.clear();
        }
    }

    public Object clone() {
        FastTreeMap fastTreeMap = null;
        if (this.fast) {
            fastTreeMap = new FastTreeMap((SortedMap)this.map);
        } else {
            TreeMap treeMap = this.map;
            synchronized (treeMap) {
                fastTreeMap = new FastTreeMap((SortedMap)this.map);
            }
        }
        fastTreeMap.setFast(this.getFast());
        return fastTreeMap;
    }

    public Comparator comparator() {
        if (this.fast) {
            return this.map.comparator();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Comparator comparator = this.map.comparator();
            return comparator;
        }
    }

    public boolean containsKey(Object object) {
        if (this.fast) {
            return this.map.containsKey(object);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            boolean bl = this.map.containsKey(object);
            return bl;
        }
    }

    public boolean containsValue(Object object) {
        if (this.fast) {
            return this.map.containsValue(object);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            boolean bl = this.map.containsValue(object);
            return bl;
        }
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.fast) {
            if (map.size() != this.map.size()) {
                return false;
            }
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (!(v == null ? map.get(k) != null || !map.containsKey(k) : !v.equals(map.get(k)))) continue;
                return false;
            }
            return true;
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            if (map.size() != this.map.size()) {
                boolean bl = false;
                return bl;
            }
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (v == null) {
                    if (map.get(k) == null && map.containsKey(k)) continue;
                    boolean bl = false;
                    return bl;
                }
                if (v.equals(map.get(k))) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public Object firstKey() {
        if (this.fast) {
            return this.map.firstKey();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Object k = this.map.firstKey();
            return k;
        }
    }

    public Object get(Object object) {
        if (this.fast) {
            return this.map.get(object);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Object v = this.map.get(object);
            return v;
        }
    }

    public int hashCode() {
        if (this.fast) {
            int n = 0;
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                n += ((Object)iterator.next()).hashCode();
            }
            return n;
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            int n = 0;
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                n += ((Object)iterator.next()).hashCode();
            }
            int n2 = n;
            return n2;
        }
    }

    public SortedMap headMap(Object object) {
        if (this.fast) {
            return this.map.headMap(object);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            SortedMap sortedMap = this.map.headMap(object);
            return sortedMap;
        }
    }

    public boolean isEmpty() {
        if (this.fast) {
            return this.map.isEmpty();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            boolean bl = this.map.isEmpty();
            return bl;
        }
    }

    public Set keySet() {
        return new KeySet();
    }

    public Object lastKey() {
        if (this.fast) {
            return this.map.lastKey();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Object k = this.map.lastKey();
            return k;
        }
    }

    public Object put(Object object, Object object2) {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap treeMap = (TreeMap)this.map.clone();
                Object object3 = treeMap.put(object, object2);
                this.map = treeMap;
                Object object4 = object3;
                return object4;
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Object object5 = this.map.put(object, object2);
            return object5;
        }
    }

    public void putAll(Map map) {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap treeMap = (TreeMap)this.map.clone();
                treeMap.putAll(map);
                this.map = treeMap;
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            this.map.putAll(map);
        }
    }

    public Object remove(Object object) {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap treeMap = (TreeMap)this.map.clone();
                Object v = treeMap.remove(object);
                this.map = treeMap;
                Object v2 = v;
                return v2;
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Object v = this.map.remove(object);
            return v;
        }
    }

    public int size() {
        if (this.fast) {
            return this.map.size();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            int n = this.map.size();
            return n;
        }
    }

    public SortedMap subMap(Object object, Object object2) {
        if (this.fast) {
            return this.map.subMap(object, object2);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            SortedMap sortedMap = this.map.subMap(object, object2);
            return sortedMap;
        }
    }

    public SortedMap tailMap(Object object) {
        if (this.fast) {
            return this.map.tailMap(object);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            SortedMap sortedMap = this.map.tailMap(object);
            return sortedMap;
        }
    }

    public Collection values() {
        return new Values();
    }

    private abstract class CollectionView
    implements Collection {
        protected abstract Collection get(Map var1);

        protected abstract Object iteratorNext(Map.Entry var1);

        public void clear() {
            if (FastTreeMap.this.fast) {
                FastTreeMap fastTreeMap = FastTreeMap.this;
                synchronized (fastTreeMap) {
                    TreeMap treeMap = (TreeMap)FastTreeMap.this.map.clone();
                    this.get(treeMap).clear();
                    FastTreeMap.this.map = treeMap;
                }
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                this.get(FastTreeMap.this.map).clear();
            }
        }

        public boolean remove(Object object) {
            if (FastTreeMap.this.fast) {
                FastTreeMap fastTreeMap = FastTreeMap.this;
                synchronized (fastTreeMap) {
                    TreeMap treeMap = (TreeMap)FastTreeMap.this.map.clone();
                    boolean bl = this.get(treeMap).remove(object);
                    FastTreeMap.this.map = treeMap;
                    boolean bl2 = bl;
                    return bl2;
                }
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                boolean bl = this.get(FastTreeMap.this.map).remove(object);
                return bl;
            }
        }

        public boolean removeAll(Collection collection) {
            if (FastTreeMap.this.fast) {
                FastTreeMap fastTreeMap = FastTreeMap.this;
                synchronized (fastTreeMap) {
                    TreeMap treeMap = (TreeMap)FastTreeMap.this.map.clone();
                    boolean bl = this.get(treeMap).removeAll(collection);
                    FastTreeMap.this.map = treeMap;
                    boolean bl2 = bl;
                    return bl2;
                }
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                boolean bl = this.get(FastTreeMap.this.map).removeAll(collection);
                return bl;
            }
        }

        public boolean retainAll(Collection collection) {
            if (FastTreeMap.this.fast) {
                FastTreeMap fastTreeMap = FastTreeMap.this;
                synchronized (fastTreeMap) {
                    TreeMap treeMap = (TreeMap)FastTreeMap.this.map.clone();
                    boolean bl = this.get(treeMap).retainAll(collection);
                    FastTreeMap.this.map = treeMap;
                    boolean bl2 = bl;
                    return bl2;
                }
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                boolean bl = this.get(FastTreeMap.this.map).retainAll(collection);
                return bl;
            }
        }

        public int size() {
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).size();
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                int n = this.get(FastTreeMap.this.map).size();
                return n;
            }
        }

        public boolean isEmpty() {
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).isEmpty();
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                boolean bl = this.get(FastTreeMap.this.map).isEmpty();
                return bl;
            }
        }

        public boolean contains(Object object) {
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).contains(object);
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                boolean bl = this.get(FastTreeMap.this.map).contains(object);
                return bl;
            }
        }

        public boolean containsAll(Collection collection) {
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).containsAll(collection);
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                boolean bl = this.get(FastTreeMap.this.map).containsAll(collection);
                return bl;
            }
        }

        public Object[] toArray(Object[] objectArray) {
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).toArray(objectArray);
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                Object[] objectArray2 = this.get(FastTreeMap.this.map).toArray(objectArray);
                return objectArray2;
            }
        }

        public Object[] toArray() {
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).toArray();
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                Object[] objectArray = this.get(FastTreeMap.this.map).toArray();
                return objectArray;
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).equals(object);
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                boolean bl = this.get(FastTreeMap.this.map).equals(object);
                return bl;
            }
        }

        public int hashCode() {
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).hashCode();
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                int n = this.get(FastTreeMap.this.map).hashCode();
                return n;
            }
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return new CollectionViewIterator();
        }

        private class CollectionViewIterator
        implements Iterator {
            private Map expected;
            private Map.Entry lastReturned = null;
            private Iterator iterator;

            public CollectionViewIterator() {
                this.expected = ((CollectionView)CollectionView.this).FastTreeMap.this.map;
                this.iterator = this.expected.entrySet().iterator();
            }

            public boolean hasNext() {
                if (this.expected != ((CollectionView)CollectionView.this).FastTreeMap.this.map) {
                    throw new ConcurrentModificationException();
                }
                return this.iterator.hasNext();
            }

            public Object next() {
                if (this.expected != ((CollectionView)CollectionView.this).FastTreeMap.this.map) {
                    throw new ConcurrentModificationException();
                }
                this.lastReturned = (Map.Entry)this.iterator.next();
                return CollectionView.this.iteratorNext(this.lastReturned);
            }

            public void remove() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (((CollectionView)CollectionView.this).FastTreeMap.this.fast) {
                    FastTreeMap fastTreeMap = FastTreeMap.this;
                    synchronized (fastTreeMap) {
                        if (this.expected != ((CollectionView)CollectionView.this).FastTreeMap.this.map) {
                            throw new ConcurrentModificationException();
                        }
                        FastTreeMap.this.remove(this.lastReturned.getKey());
                        this.lastReturned = null;
                        this.expected = ((CollectionView)CollectionView.this).FastTreeMap.this.map;
                    }
                } else {
                    this.iterator.remove();
                    this.lastReturned = null;
                }
            }
        }
    }

    private class EntrySet
    extends CollectionView
    implements Set {
        private EntrySet() {
        }

        protected Collection get(Map map) {
            return map.entrySet();
        }

        protected Object iteratorNext(Map.Entry entry) {
            return entry;
        }
    }

    private class KeySet
    extends CollectionView
    implements Set {
        private KeySet() {
        }

        protected Collection get(Map map) {
            return map.keySet();
        }

        protected Object iteratorNext(Map.Entry entry) {
            return entry.getKey();
        }
    }

    private class Values
    extends CollectionView {
        private Values() {
        }

        protected Collection get(Map map) {
            return map.values();
        }

        protected Object iteratorNext(Map.Entry entry) {
            return entry.getValue();
        }
    }
}

