package pl.helion.jeeweb.przychodnie.controllers;

import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.persistence.EntityManager;
import javax.persistence.RollbackException;
import pl.helion.jeeweb.przychodnie.config.DBManager;
import pl.helion.jeeweb.przychodnie.entity.Wizyta;
import pl.helion.jeeweb.przychodnie.entity.WizytaPK;

public class WizytaBean {
    private Wizyta wizyta;
    private Wizyta staraWizyta;
    private int przychodniaID;

    public WizytaBean() {
        this.inicjujWizyte();
    }

    private void inicjujWizyte() {
        this.wizyta = new Wizyta();
        this.wizyta.setWizytaPK(new WizytaPK());
        this.staraWizyta = null;
    }

    public Wizyta getWizyta() {
        return wizyta;
    }

    public void setWizyta(Wizyta wizyta) {
        this.wizyta = wizyta;
    }

    public int getPrzychodniaID() {
        return przychodniaID;
    }

    public void setPrzychodniaID(int przychodniaID) {
        this.przychodniaID = przychodniaID;
    }

    public String dodaj() {
        EntityManager em = DBManager.getManager().createEntityManager();
        em.getTransaction().begin();
        em.persist(wizyta);
        try {
            em.getTransaction().commit();
        } catch (RollbackException re) {
            this.dodajInformacje("Nie udalo sie dodac wizyty - upewnij sie, ze taka wizyta nie istnieje!");
            return null;
        }
        finally {
            em.close();
        }
        this.dodajInformacje("Dodano wizyte!");
        this.inicjujWizyte();
        return null;
    }
    

    public List<Wizyta> getListaWizyt() {
        EntityManager em = DBManager.getManager().createEntityManager();
        List<Wizyta> lista = em.createQuery("from Wizyta w WHERE w.lekarz1.przychodnia.id=:id").setParameter("id", this.getPrzychodniaID()).getResultList();
        em.close();
        return lista;
    }

    public void dodajInformacje(String s) {
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, s,""));
    }

    public void wizytaListener(ActionEvent ae) {
        String kluczTekst = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("wizytaPK").toString();
        WizytaPK klucz = Wizyta.convertStringAsWizytaPK(kluczTekst);
        this.wizyta = new Wizyta();
        this.wizyta.setWizytaPK(klucz);
    }

    public String zaladujDoEdycji() {
        EntityManager em = DBManager.getManager().createEntityManager();
        this.wizyta = em.find(Wizyta.class, wizyta.getWizytaPK());
        this.staraWizyta = new Wizyta(wizyta.getWizytaPK().getLekarz(), wizyta.getWizytaPK().getPacjent(), wizyta.getWizytaPK().getData());
        this.staraWizyta.setPokoj(this.wizyta.getPokoj());
        em.close();
        return "/edytujwizyte.xhtml";
    }

    public String usun() {
        EntityManager em = DBManager.getManager().createEntityManager();
        em.getTransaction().begin();
        this.wizyta = em.find(Wizyta.class, wizyta.getWizytaPK());
        em.remove(this.wizyta);
        this.inicjujWizyte();
        em.getTransaction().commit();
        em.close();
        this.dodajInformacje("Usunieto wizyte!");
        return null;
    }

    public String edytuj() {
        EntityManager em = DBManager.getManager().createEntityManager();
        em.getTransaction().begin();
        System.out.println(this.wizyta.getWizytaPK().getData().toString()+" "+this.staraWizyta.getWizytaPK().getData().toString());
        if (this.wizyta.equals(this.staraWizyta))
            em.merge(this.wizyta);
        else {
            em.remove(em.find(Wizyta.class, this.staraWizyta.getWizytaPK()));
            em.persist(this.wizyta);
        }
        try {
            em.getTransaction().commit();
        } catch (RollbackException re) {
            this.dodajInformacje("Nie udalo sie zmienic danych wizyty - upewnij sie, ze taka wizyta nie istnieje!");
            return null;
        }
        finally {
            em.close();
        }
        this.dodajInformacje("Zmieniono dane wizyty!");
        this.inicjujWizyte();
        return "/pokazwizyty.xhtml";
    }
}
