/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class PropertyMetadata
extends ORMetadata {
    private String m_name;
    private String m_value;
    private MetadataClass m_valueType;
    private String m_valueTypeName;

    public PropertyMetadata() {
        super("<property>");
    }

    public PropertyMetadata(MetadataAnnotation property, MetadataAccessor accessor) {
        super(property, accessor);
        this.m_name = property.getAttributeString("name");
        this.m_value = property.getAttributeString("value");
        this.m_valueType = this.getMetadataClass(property.getAttributeClass("valueType", String.class));
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof PropertyMetadata) {
            PropertyMetadata property = (PropertyMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, property.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_value, property.getValue())) {
                return false;
            }
            return this.valuesMatch(this.m_valueTypeName, property.getValueTypeName());
        }
        return false;
    }

    @Override
    public String getIdentifier() {
        return this.getName();
    }

    public String getName() {
        return this.m_name;
    }

    public String getValue() {
        return this.m_value;
    }

    public MetadataClass getValueType() {
        return this.m_valueType;
    }

    public String getValueTypeName() {
        return this.m_valueTypeName;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_valueType = this.m_valueTypeName != null ? this.initXMLClassName(this.m_valueTypeName) : this.getMetadataClass(String.class);
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setValue(String value) {
        this.m_value = value;
    }

    public void setValueType(MetadataClass valueType) {
        this.m_valueType = valueType;
    }

    public void setValueTypeName(String valueTypeName) {
        this.m_valueTypeName = valueTypeName;
    }
}

