/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.store.access.StoreCostResult;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.btree.SearchParameters;

public class BTreeCostController
extends OpenBTree
implements StoreCostController {
    private static final double BTREE_CACHED_FETCH_BY_KEY_PER_LEVEL = 0.2705;
    private static final double BTREE_SORTMERGE_FETCH_BY_KEY_PER_LEVEL = 0.716;
    private static final double BTREE_UNCACHED_FETCH_BY_KEY_PER_LEVEL = 1.5715;
    TransactionManager init_xact_manager;
    Transaction init_rawtran;
    Conglomerate init_conglomerate;
    long num_pages;
    long num_rows;
    long page_size;
    int tree_height;

    public void init(TransactionManager transactionManager, BTree bTree, Transaction transaction) throws StandardException {
        super.init(transactionManager, transactionManager, null, transaction, false, 8, 5, null, bTree, null, null);
        this.num_pages = this.container.getEstimatedPageCount(0);
        this.num_rows = this.container.getEstimatedRowCount(0) - this.num_pages;
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", "");
        this.container.getContainerProperties(properties);
        this.page_size = Integer.parseInt(properties.getProperty("derby.storage.pageSize"));
        this.tree_height = this.getHeight();
    }

    public void close() throws StandardException {
        super.close();
    }

    public double getFetchFromRowLocationCost(FormatableBitSet formatableBitSet, int n) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public double getFetchFromFullKeyCost(FormatableBitSet formatableBitSet, int n) throws StandardException {
        double d = (n & 1) == 0 ? 1.5715 : 0.716;
        return d *= (double)this.tree_height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getScanCost(int n, long l, int n2, boolean bl, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, int n3, DataValueDescriptor[] dataValueDescriptorArray3, int n4, boolean bl2, int n5, StoreCostResult storeCostResult) throws StandardException {
        ControlRow controlRow = null;
        long l2 = l < 0L ? this.num_rows : l;
        try {
            float f;
            float f2;
            SearchParameters searchParameters;
            float f3;
            if (dataValueDescriptorArray2 == null) {
                f3 = 0.0f;
            } else {
                searchParameters = new SearchParameters(dataValueDescriptorArray2, n3 == 1 ? 1 : -1, dataValueDescriptorArray, this, true);
                controlRow = ControlRow.get(this, 1L).search(searchParameters);
                controlRow.release();
                controlRow = null;
                f3 = searchParameters.left_fraction;
            }
            if (dataValueDescriptorArray3 == null) {
                f2 = 1.0f;
            } else {
                searchParameters = new SearchParameters(dataValueDescriptorArray3, n4 == 1 ? 1 : -1, dataValueDescriptorArray, this, true);
                controlRow = ControlRow.get(this, 1L).search(searchParameters);
                controlRow.release();
                controlRow = null;
                f2 = searchParameters.left_fraction;
            }
            float f4 = f2 - f3;
            if (f4 < 0.0f) {
                f4 = 0.0f;
            }
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            if ((f = (float)l2 * f4) < 1.0f) {
                f = 1.0f;
            }
            double d = this.getFetchFromFullKeyCost(formatableBitSet, n5);
            d += (double)((float)this.num_pages * f4) * 1.5;
            long l3 = (long)f - this.num_pages;
            if (l3 < 0L) {
                l3 = 0L;
            }
            d = n == 2 ? (d += (double)l3 * 0.12) : (d += (double)l3 * 0.14);
            long l4 = l2 == 0L ? 4L : this.num_pages * this.page_size / l2;
            storeCostResult.setEstimatedCost(d += (double)(f * (float)l4) * 0.004);
            storeCostResult.setEstimatedRowCount(Math.round(f));
        }
        finally {
            if (controlRow != null) {
                controlRow.release();
            }
        }
    }

    public RowLocation newRowLocationTemplate() throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }
}

