/*
 * Copyright 2011 Oracle and/or its affiliates.
 * All rights reserved.  You may not modify, use,
 * reproduce, or distribute this software except in
 * compliance with  the terms of the License at:
 * http://developers.sun.com/license/berkeley_license.html
 */


package servlets;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 * This is a simple example of an HTTP Servlet.  It responds to the GET
 * method of the HTTP protocol.
 */
@WebServlet("/greeting")
public class GreetingServlet extends HttpServlet {
    @Override
    public void doGet(
        HttpServletRequest request,
        HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.setBufferSize(8192);

        PrintWriter out = response.getWriter();

        // utwórz nagłówek odpowiedzi
        out.println(
                "<html lang=\"pl\">"
                + "<head><title>Serwlet Hello</title></head>");

        // utwórz sekcję body odpowiedzi
        out.println(
                "<body  bgcolor=\"#ffffff\">"
                + "<img src=\"duke.waving.gif\" alt=\"Machający ręką Duke\">"
                + "<form method=\"get\">"
                + "<h2>Cześć, nazywam się Duke. Jak masz na imię?</h2>"
                + "<input title=\"Mam na imię: \" type=\"text\" name=\"username\" size=\"25\"/>"
                + "<p></p>" + "<input type=\"submit\" value=\"Wyślij\"/>"
                + "<input type=\"reset\" value=\"Wyczyść\"/>" + "</form>");

        String username = request.getParameter("username");

        if ((username != null) && (username.length() > 0)) {
            RequestDispatcher dispatcher = getServletContext()
                                               .getRequestDispatcher(
                        "/response");

            if (dispatcher != null) {
                dispatcher.include(request, response);
            }
        }

        out.println("</body></html>");
        out.close();
    }

    @Override
    public String getServletInfo() {
        return "Serwlet Hello mówi cześć.";
    }
}
