/*
 * Copyright 2011 Oracle and/or its affiliates.
 * All rights reserved.  You may not modify, use,
 * reproduce, or distribute this software except in
 * compliance with  the terms of the License at:
 * http://developers.sun.com/license/berkeley_license.html
 */


/*
 * Copyright 2009 Sun Microsystems, Inc.
 * All rights reserved.  You may not modify, use,
 * reproduce, or distribute this software except in
 * compliance with  the terms of the License at:
 * http://developer.sun.com/berkeley_license.html
 */
package cart.client;

import java.util.Iterator;
import java.util.List;
import javax.ejb.EJB;
import cart.ejb.Cart;
import cart.util.BookException;


/**
 *
 * Klasa klienta przykładowego komponentu CartBean. Klient dodaje książki do 
 * koszyka, wyświetla jego zawartość i usuwa książkę, której jeszcze nie dodano 
 * wywołując wyjątek BookException.
 * @author ian
 */
public class CartClient {
    @EJB
    private static Cart cart;

    public CartClient(String[] args) {
    }

    /**
     * @param args argumenty linii poleceń
     */
    public static void main(String[] args) {
        CartClient client = new CartClient(args);
        client.doTest();
    }

    public void doTest() {
        try {
            cart.initialize("Java EE 6. Programowanie aplikacji WWW", "123");
            cart.addBook("Java. Podstawy. Wydanie VIII");
            cart.addBook("Enterprise JavaBeans");
            cart.addBook("JavaServer Faces. Wydanie III");

            List<String> bookList = cart.getContents();

            bookList = cart.getContents();

            Iterator<String> iterator = bookList.iterator();

            while (iterator.hasNext()) {
                String title = iterator.next();
                System.out.println("Odczytywanie z koszyka tytułu książki: " + title);
            }

            System.out.println("Usuwanie \"Thinking in Java\" z koszyka.");
            cart.removeBook("Thinking in Java");
            cart.remove();

            System.exit(0);
        } catch (BookException ex) {
            System.err.println("Z�apano wyj�tek BookException: " + ex.getMessage());
            System.exit(1);
        } catch (Exception ex) {
            System.err.println("Złapano nieoczekiwany wyjątek!");
            ex.printStackTrace();
            System.exit(1);
        }
    }
}
