/*
 * Copyright 2011 Oracle and/or its affiliates.
 * All rights reserved.  You may not modify, use,
 * reproduce, or distribute this software except in
 * compliance with  the terms of the License at:
 * http://developers.sun.com/license/berkeley_license.html
 */


package rsvp.entity;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import rsvp.util.ResponseEnum;


@NamedQuery(name = "rsvp.entity.Response.findResponseByEventAndPerson", query = "SELECT r "
+ "FROM Response r " + "JOIN r.event e " + "JOIN r.person p "
+ "WHERE e.id = :eventId AND p.id = :personId")
@Entity
public class Response implements Serializable {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    private Event event;
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Long id;
    @ManyToOne
    private Person person;
    @Enumerated(EnumType.STRING)
    private ResponseEnum response;

    public Response() {
        this.setResponse(ResponseEnum.NOT_RESPONDED);
    }

    public Response(
        Event event,
        Person person,
        ResponseEnum response) {
        this.setEvent(event);
        this.setPerson(person);
        this.setResponse(response);
    }

    public Response(
        Event event,
        Person person) {
        this.setEvent(event);
        this.setPerson(person);
        this.setResponse(ResponseEnum.NOT_RESPONDED);
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += ((id != null) ? id.hashCode() : 0);

        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Uwaga - ta metoda nie zadziała jeśli wartości pól id nie zostały ustawione
        if (!(object instanceof Response)) {
            return false;
        }

        Response other = (Response) object;

        if (((this.id == null) && (other.id != null))
                || ((this.id != null) && !this.id.equals(other.id))) {
            return false;
        }

        return true;
    }

    @Override
    public String toString() {
        return "rsvp.entity.Response[id=" + id + "]";
    }

    /**
     * @return wydarzenie
     */
    public Event getEvent() {
        return event;
    }

    /**
     * @param event ustawiane wydarzenie
     */
    public void setEvent(Event event) {
        this.event = event;
    }

    /**
     * @return osoba
     */
    public Person getPerson() {
        return person;
    }

    /**
     * @param person ustawiana osoba
     */
    public void setPerson(Person person) {
        this.person = person;
    }

    /**
     * @return odpowiedź
     */
    public ResponseEnum getResponse() {
        return response;
    }

    /**
     * @param response ustawiana odpowiedź
     */
    public void setResponse(ResponseEnum response) {
        this.response = response;
    }

    public String getResponseText() {
        String responseText;

        if (this.response == ResponseEnum.ATTENDING) {
            responseText = "Weźmie udział";
        } else if (this.response == ResponseEnum.MAYBE_ATTENDING) {
            responseText = "Być może weźmie udział";
        } else if (this.response == ResponseEnum.NOT_ATTENDING) {
            responseText = "Nie weźmie udziału";
        } else if (this.response == ResponseEnum.NOT_RESPONDED) {
            responseText = "Jeszcze nie odpowiedział";
        } else {
            responseText = "nieznany";
        }

        return responseText;
    }
}
