/*
 * Copyright 2011 Oracle and/or its affiliates.
 * All rights reserved.  You may not modify, use,
 * reproduce, or distribute this software except in
 * compliance with  the terms of the License at:
 * http://developers.sun.com/license/berkeley_license.html
 */
package webclient;

import helloservice.endpoint.HelloService;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceRef;

@WebServlet(name = "HelloServlet", urlPatterns = {
    "/HelloServlet"})
public class HelloServlet extends HttpServlet {

    @WebServiceRef(wsdlLocation = "WEB-INF/wsdl/localhost_8080/helloservice/HelloService.wsdl")
    private HelloService service;

    /**
     * Przetwarza żądanie dla obu metod HTTP: <code>GET</code>
     *   i <code>POST</code>.
     * @param request żądanie przychodzące do serwletu
     * @param response odpowiedź serwletu
     * @throws ServletException jeśli wystapi jakikolwiek błąd charakterystyczny dla serwletu
     * @throws IOException jeśli wystąpi błąd wejścia/wyjścia
     */
    protected void processRequest(
            HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");

        PrintWriter out = response.getWriter();

        try {
            out.println("<html lang=\"pl\">");
            out.println("<head>");
            out.println("<title>Servlet HelloServlet</title>");
            out.println("</head>");
            out.println("<body>");
            out.println(
                    "<h1>Serwlet HelloServlet na " + request.getContextPath()
                    + "</h1>");
            out.println("<p>" + sayHello("świecie") + "</p>");
            out.println("</body>");
            out.println("</html>");
        } finally {
            out.close();
        }
    }

    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /**
     * Obsługuje metodę HTTP <code>GET</code>.
     * @param request żądanie przychodzące do serwletu
     * @param response odpowiedź serwletu
     * @throws ServletException jeśli wystapi jakikolwiek błąd charakterystyczny dla serwletu
     * @throws IOException jeśli wystąpi błąd wejścia/wyjścia
     */
    @Override
    protected void doGet(
            HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {
        processRequest(request, response);
    }

    /**
     * Obsługuje metodę HTTP <code>POST</code>.
     * @param request żądanie przychodzące do serwletu
     * @param response odpowiedź serwletu
     * @throws ServletException jeśli wystapi jakikolwiek błąd charakterystyczny dla serwletu
     * @throws IOException jeśli wystąpi błąd wejścia/wyjścia
     */
    @Override
    protected void doPost(
            HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {
        processRequest(request, response);
    }

    /**
     * Zwraca krótki opis serwletu.
     * @return łańcuch znaków zawierający opis serwletu
     */
    @Override
    public String getServletInfo() {
        return "Krótki opis";
    } // </editor-fold>

    private String sayHello(java.lang.String arg0) {
        helloservice.endpoint.Hello port = service.getHelloPort();

        return port.sayHello(arg0);
    }
}
