/*
 * Copyright 2011 Oracle and/or its affiliates.
 * All rights reserved.  You may not modify, use,
 * reproduce, or distribute this software except in
 * compliance with  the terms of the License at:
 * http://developers.sun.com/license/berkeley_license.html
 */


package rsvp.ejb;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import rsvp.entity.Event;
import rsvp.entity.Person;
import rsvp.entity.Response;
import rsvp.util.ResponseEnum;


@Stateless
@Path("/{eventId}/{inviteId}")
public class ResponseBean {
    @PersistenceContext
    private EntityManager em;

    @GET
    @Produces("text/html")
    public String getResponse(
        @PathParam("eventId")
    Long eventId,
        @PathParam("inviteId")
    Long personId) {
        StringBuilder output = new StringBuilder();
        Response response = (Response) em.createNamedQuery(
                    "rsvp.entity.Response.findResponseByEventAndPerson")
                                         .setParameter("eventId", eventId)
                                         .setParameter("personId", personId)
                                         .getSingleResult();
        Event event = response.getEvent();
        Person person = response.getPerson();
        output.append("<html lang=\"pl\"><head>")
              .append("<meta http-equiv=\"Content-type\" content=\"text/html;charset=UTF-8\">")
              .append("<title>Aktualne odpowiedzi dla ")
              .append(person.getFirstName())
              .append(" ")
              .append(person.getLastName())
              .append(" at ")
              .append(event.getName())
              .append("</title>")
              .append(
                "<link href=\"/rsvp/css/default.css\" rel=\"stylesheet\" type=\"text/css\" />")
              .append("</head>");
        output.append("<body><h1>")
              .append(event.getName())
              .append("</h1>");
        output.append("<p>Witaj ")
              .append(person.getFirstName())
              .append("!</p>");
        output.append("<p>");
        output.append("Twoja aktualna odpowiedź to: ")
              .append(response.getResponseText());
        output.append("</p>");

        output.append(
                "<form name=\"submitResponse\" action=\"/rsvp/resources/")
              .append(event.getId())
              .append("/")
              .append(person.getId())
              .append("\" method=\"POST\">");
        output.append("<p>Czy weźmiesz udział w ")
              .append(event.getName())
              .append("?</p>");
        output.append("<select title=\"Odpowiedź\" name=\"attendeeResponse\">");
        output.append("<option>Tak</option>");
        output.append("<option>Może</option>");
        output.append("<option>Nie</option>");
        output.append("</select>");
        output.append("<br/>");
        output.append(
                "<input type=\"submit\" value=\"Wyślij odpowiedź\" name=\"attendeeResponseButton\"/>");
        output.append("</form>");

        output.append("</body></html>");

        return output.toString();
    }

    @POST
    @Consumes("application/x-www-form-urlencoded")
    @Produces("text/html")
    public String putResponse(
        @FormParam("attendeeResponse")
    String userResponse,
        @PathParam("eventId")
    Long eventId,
        @PathParam("inviteId")
    Long personId) {
        StringBuilder output = new StringBuilder();
        Response response = (Response) em.createNamedQuery(
                    "rsvp.entity.Response.findResponseByEventAndPerson")
                                         .setParameter("eventId", eventId)
                                         .setParameter("personId", personId)
                                         .getSingleResult();
        Event event = response.getEvent();
        Person person = response.getPerson();

        if (userResponse.equals("Tak")
                && !response.getResponse()
                                .equals(ResponseEnum.ATTENDING)) {
            response.setResponse(ResponseEnum.ATTENDING);
            em.merge(response);
        } else if (userResponse.equals("Nie")
                && !response.getResponse()
                                .equals(ResponseEnum.NOT_ATTENDING)) {
            response.setResponse(ResponseEnum.NOT_ATTENDING);
            em.merge(response);
        } else if (userResponse.equals("Może")
                && !response.getResponse()
                                .equals(ResponseEnum.MAYBE_ATTENDING)) {
            response.setResponse(ResponseEnum.MAYBE_ATTENDING);
            em.merge(response);
        }

        // stwórz odpowiedź HTML
        output.append("<html lang=\"pl\"><head>")
              .append("<meta http-equiv=\"Content-type\" content=\"text/html;charset=UTF-8\">")
              .append("<title>Aktualne odpowiedzi dla ")
              .append(person.getFirstName())
              .append(" ")
              .append(person.getLastName())
              .append(" at ")
              .append(event.getName())
              .append("</title>")
              .append(
                "<link href=\"/rsvp/css/default.css\" rel=\"stylesheet\" type=\"text/css\" />")
              .append("</head>");
        output.append("<body><h1>")
              .append(event.getName())
              .append("</h1>");
        output.append("<p>Dziękujemy za odpowiedź, ")
              .append(person.getFirstName())
              .append(" ")
              .append(person.getLastName())
              .append("!</p>");
        output.append("<p>Twoja aktualna odpowiedź to: ")
              .append(response.getResponseText())
              .append("</p>");
        output.append("<p><a href=\"/rsvp/resources/status/")
              .append(event.getId())
              .append("\">Wróć do strony wydarzenia</a></p>");
        output.append("</body></html>");

        return output.toString();
    }
}
