/*
 * Copyright 2011 Oracle and/or its affiliates.
 * All rights reserved.  You may not modify, use,
 * reproduce, or distribute this software except in
 * compliance with  the terms of the License at:
 * http://developers.sun.com/license/berkeley_license.html
 */


package rsvp.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;


@Entity
public class Person implements Serializable {
    @ManyToOne
    private static final long serialVersionUID = 1L;
    protected String firstName;
    protected String lastName;
    @ManyToMany(mappedBy = "invitees")
    private List<Event> events;
    @OneToMany(mappedBy = "owner")
    private List<Event> ownedEvents;
    @OneToMany(mappedBy = "person")
    private List<Response> responses;
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Long id;

    public Person() {
        this.events = new ArrayList<Event>();
        this.ownedEvents = new ArrayList<Event>();
        this.responses = new ArrayList<Response>();
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /**
     * Pobiera wartość pola firstName zawierajacego imię
     *
     * @return wartość pola firstName
     */
    public String getFirstName() {
        return firstName;
    }

    /**
     * Ustawia wartość pola firstName zawierajacego imię
     *
     * @param firstName nowa wartość pola firstName
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /**
     * Pobiera wartość pola lastName zawierajacego nazwisko
     *
     * @return wartość pola lastName
     */
    public String getLastName() {
        return lastName;
    }

    /**
     * Ustawia wartość pola lastName zawierajacego nazwisko
     *
     * @param lastName nowa wartość pola lastName
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += ((id != null) ? id.hashCode() : 0);

        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Uwaga - ta metoda nie zadziała jeśli wartości pól id nie zostały ustawione
        if (!(object instanceof Person)) {
            return false;
        }

        Person other = (Person) object;

        if (((this.id == null) && (other.id != null))
                || ((this.id != null) && !this.id.equals(other.id))) {
            return false;
        }

        return true;
    }

    @Override
    public String toString() {
        return "rsvp.entity.Person[id=" + id + "]";
    }

    /**
     * @return wydarzenia
     */
    public List<Event> getEvents() {
        return events;
    }

    /**
     * @param events ustawiane wydarzenia
     */
    public void setEvents(List<Event> events) {
        this.events = events;
    }

    /**
     * @return posiadane wydarzenia
     */
    public List<Event> getOwnedEvents() {
        return ownedEvents;
    }

    /**
     * @param ownedEvents ustawiane posiadane wydarzenia
     */
    public void setOwnedEvents(List<Event> ownedEvents) {
        this.ownedEvents = ownedEvents;
    }

    /**
     * @return odpowiedzi
     */
    public List<Response> getResponses() {
        return responses;
    }

    /**
     * @param responses ustawiane odpowiedzi
     */
    public void setResponses(List<Response> responses) {
        this.responses = responses;
    }
}
