/*
 * Copyright 2011 Oracle and/or its affiliates.
 * All rights reserved.  You may not modify, use,
 * reproduce, or distribute this software except in
 * compliance with  the terms of the License at:
 * http://developers.sun.com/license/berkeley_license.html
 */


package converter.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import javax.ejb.EJB;
import javax.servlet.annotation.WebServlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import converter.ejb.ConverterBean;


@WebServlet
public class ConverterServlet extends HttpServlet {
    @EJB
    ConverterBean converter;

    /**
     * Przetwarza żądanie dla obu metod HTTP: <code>GET</code>
     *   i <code>POST</code>.
     * @param request żądanie przychodzące do serwletu
     * @param response odpowiedź serwletu
     * @throws ServletException jeśli wystapi jakikolwiek błąd charakterystyczny dla serwletu
     * @throws IOException jeśli wystąpi błąd wejścia/wyjścia
     */
    protected void processRequest(
        HttpServletRequest request,
        HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");

        PrintWriter out = response.getWriter();
        // Wyświetl wyniki
        out.println("<html lang=\"pl\">");
        out.println("<head>");
        out.println("<title>Serwlet ConverterServlet</title>");
        out.println("</head>");
        out.println("<body>");
        out.println(
                "<h1>Serwlet ConverterServlet na " + request.getContextPath()
                + "</h1>");

        try {
            String amount = request.getParameter("amount");

            if ((amount != null) && (amount.length() > 0)) {                
                // skonwertuj amount z parametru żądania na BigDecimal
                BigDecimal d = new BigDecimal(amount);

                // wywołaj metodę ConverterBean.dollarToYen() aby otrzymać kwotę w jenach
                BigDecimal yenAmount = converter.dollarToYen(d);

                // wywołaj metodę ConverterBean.dollarToYen() aby otrzymać kwotę w euro
                BigDecimal euroAmount = converter.yenToEuro(yenAmount);

                out.println(
                        "<p>" + amount + " dolarów to "
                        + yenAmount.toPlainString() + " jenów.</p>");
                out.println(
                        "<p>" + yenAmount.toPlainString() + " jenów to "
                        + euroAmount.toPlainString() + " euro.</p>");
            } else {
                out.println("<p>Podaj kwotę w dolarach, jaką chcesz przeliczyć:</p>");
                out.println("<form method=\"get\">");
                out.println(
                        "<p><input title=\"Kwota\" type=\"text\" name=\"amount\" size=\"25\"> $</p>");
                out.println("<br/>");
                out.println(
                        "<input type=\"submit\" value=\"Wyślij\">"
                        + "<input type=\"reset\" value=\"Wyczyść\">");
                out.println("</form>");
            }
        } finally {
            out.println("</body>");
            out.println("</html>");
            out.close();
        }
    }

    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /**
     * Obsługuje metodę HTTP <code>GET</code>.
     * @param request żądanie przychodzące do serwletu
     * @param response odpowiedź serwletu
     * @throws ServletException jeśli wystapi jakikolwiek błąd charakterystyczny dla serwletu
     * @throws IOException jeśli wystąpi błąd wejścia/wyjścia
     */
    @Override
    protected void doGet(
        HttpServletRequest request,
        HttpServletResponse response) throws ServletException, IOException {
        processRequest(request, response);
    }

    /**
     * Obsługuje metodę HTTP <code>POST</code>.
     * @param request żądanie przychodzące do serwletu
     * @param response odpowiedź serwletu
     * @throws ServletException jeśli wystapi jakikolwiek błąd charakterystyczny dla serwletu
     * @throws IOException jeśli wystąpi błąd wejścia/wyjścia
     */
    @Override
    protected void doPost(
        HttpServletRequest request,
        HttpServletResponse response) throws ServletException, IOException {
        processRequest(request, response);
    }

    /**
     * Zwraca krótki opis serwletu.
     * @return łańcuch znaków zawierający opis serwletu
     */
    @Override
    public String getServletInfo() {
        return "Krótki opis";
    } // </editor-fold>
}
