/*
 * Decompiled with CFR 0.152.
 */
package roster.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJBException;
import javax.ejb.Stateful;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import roster.entity.League;
import roster.entity.League_;
import roster.entity.Player;
import roster.entity.Player_;
import roster.entity.SummerLeague;
import roster.entity.Team;
import roster.entity.Team_;
import roster.entity.WinterLeague;
import roster.request.Request;
import roster.util.IncorrectSportException;
import roster.util.LeagueDetails;
import roster.util.PlayerDetails;
import roster.util.TeamDetails;

@Stateful
public class RequestBean
implements Request {
    private static final Logger logger = Logger.getLogger("roster.request.RequestBean");
    private CriteriaBuilder cb;
    @PersistenceContext
    private EntityManager em;

    @PostConstruct
    private void init() {
        this.cb = this.em.getCriteriaBuilder();
    }

    @Override
    public void createPlayer(String id, String name, String position, double salary) {
        logger.info("createPlayer");
        try {
            Player player = new Player(id, name, position, salary);
            this.em.persist((Object)player);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    @Override
    public void addPlayer(String playerId, String teamId) {
        logger.info("addPlayer");
        try {
            Player player = (Player)this.em.find(Player.class, (Object)playerId);
            Team team = (Team)this.em.find(Team.class, (Object)teamId);
            team.addPlayer(player);
            player.addTeam(team);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    @Override
    public void removePlayer(String playerId) {
        logger.info("removePlayer");
        try {
            Player player = (Player)this.em.find(Player.class, (Object)playerId);
            Collection<Team> teams = player.getTeams();
            for (Team team : teams) {
                team.dropPlayer(player);
            }
            this.em.remove((Object)player);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    @Override
    public void dropPlayer(String playerId, String teamId) {
        logger.info("dropPlayer");
        try {
            Player player = (Player)this.em.find(Player.class, (Object)playerId);
            Team team = (Team)this.em.find(Team.class, (Object)teamId);
            team.dropPlayer(player);
            player.dropTeam(team);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    @Override
    public PlayerDetails getPlayer(String playerId) {
        logger.info("getPlayerDetails");
        PlayerDetails playerDetails = null;
        try {
            Player player = (Player)this.em.find(Player.class, (Object)playerId);
            playerDetails = new PlayerDetails(player.getId(), player.getName(), player.getPosition(), player.getSalary());
            return playerDetails;
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    @Override
    public List<PlayerDetails> getPlayersOfTeam(String teamId) {
        logger.info("getPlayersOfTeam");
        List<PlayerDetails> playerList = null;
        try {
            Team team = (Team)this.em.find(Team.class, (Object)teamId);
            playerList = this.copyPlayersToDetails((List)team.getPlayers());
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
        return playerList;
    }

    @Override
    public List<TeamDetails> getTeamsOfLeague(String leagueId) {
        logger.info("getTeamsOfLeague");
        ArrayList<TeamDetails> detailsList = new ArrayList<TeamDetails>();
        Collection<Team> teams = null;
        try {
            League league = (League)this.em.find(League.class, (Object)leagueId);
            teams = league.getTeams();
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
        for (Team team : teams) {
            TeamDetails teamDetails = new TeamDetails(team.getId(), team.getName(), team.getCity());
            detailsList.add(teamDetails);
        }
        return detailsList;
    }

    @Override
    public List<PlayerDetails> getPlayersByPosition(String position) {
        logger.info("getPlayersByPosition");
        List players = null;
        try {
            CriteriaQuery cq = this.cb.createQuery(Player.class);
            if (cq != null) {
                Root player = cq.from(Player.class);
                cq.where((Expression)this.cb.equal((Expression)player.get(Player_.position), (Object)position));
                cq.select((Selection)player);
                TypedQuery q = this.em.createQuery(cq);
                players = q.getResultList();
            }
            return this.copyPlayersToDetails(players);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    @Override
    public List<PlayerDetails> getPlayersByHigherSalary(String name) {
        logger.info("getPlayersByHigherSalary");
        List players = null;
        try {
            CriteriaQuery cq = this.cb.createQuery(Player.class);
            if (cq != null) {
                Root player1 = cq.from(Player.class);
                Root player2 = cq.from(Player.class);
                Predicate gtPredicate = this.cb.greaterThan((Expression)player1.get(Player_.salary), (Expression)player2.get(Player_.salary));
                Predicate equalPredicate = this.cb.equal((Expression)player1.get(Player_.name), (Object)name);
                cq.where(new Predicate[]{gtPredicate, equalPredicate});
                cq.select((Selection)player1).distinct(true);
                TypedQuery q = this.em.createQuery(cq);
                players = q.getResultList();
            }
            return this.copyPlayersToDetails(players);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    @Override
    public List<PlayerDetails> getPlayersBySalaryRange(double low, double high) {
        logger.info("getPlayersBySalaryRange");
        List players = null;
        try {
            CriteriaQuery cq = this.cb.createQuery(Player.class);
            if (cq != null) {
                Root player = cq.from(Player.class);
                cq.where((Expression)this.cb.between((Expression)player.get(Player_.salary), (Comparable)Double.valueOf(low), (Comparable)Double.valueOf(high)));
                cq.select((Selection)player).distinct(true);
                TypedQuery q = this.em.createQuery(cq);
                players = q.getResultList();
            }
            return this.copyPlayersToDetails(players);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    @Override
    public List<PlayerDetails> getPlayersByLeagueId(String leagueId) {
        logger.info("getPlayersByLeagueId");
        List players = null;
        try {
            CriteriaQuery cq = this.cb.createQuery(Player.class);
            if (cq != null) {
                Root player = cq.from(Player.class);
                CollectionJoin team = player.join(Player_.teams);
                Join league = team.join(Team_.league);
                cq.where((Expression)this.cb.equal((Expression)league.get(League_.id), (Object)leagueId));
                cq.select((Selection)player).distinct(true);
                TypedQuery q = this.em.createQuery(cq);
                players = q.getResultList();
            }
            return this.copyPlayersToDetails(players);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    @Override
    public List<PlayerDetails> getPlayersBySport(String sport) {
        logger.info("getPlayersByLeagueId");
        List players = null;
        try {
            CriteriaQuery cq = this.cb.createQuery(Player.class);
            if (cq != null) {
                Root player = cq.from(Player.class);
                CollectionJoin team = player.join(Player_.teams);
                Join league = team.join(Team_.league);
                cq.where((Expression)this.cb.equal((Expression)league.get(League_.sport), (Object)sport));
                cq.select((Selection)player).distinct(true);
                TypedQuery q = this.em.createQuery(cq);
                players = q.getResultList();
            }
            return this.copyPlayersToDetails(players);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    @Override
    public List<PlayerDetails> getPlayersByCity(String city) {
        logger.info("getPlayersByCity");
        List players = null;
        try {
            CriteriaQuery cq = this.cb.createQuery(Player.class);
            if (cq != null) {
                Root player = cq.from(Player.class);
                CollectionJoin team = player.join(Player_.teams);
                cq.where((Expression)this.cb.equal((Expression)team.get(Team_.city), (Object)city));
                cq.select((Selection)player).distinct(true);
                TypedQuery q = this.em.createQuery(cq);
                players = q.getResultList();
            }
            return this.copyPlayersToDetails(players);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    @Override
    public List<PlayerDetails> getAllPlayers() {
        logger.info("getAllPlayers");
        List players = null;
        try {
            CriteriaQuery cq = this.cb.createQuery(Player.class);
            if (cq != null) {
                Root player = cq.from(Player.class);
                cq.select((Selection)player);
                TypedQuery q = this.em.createQuery(cq);
                players = q.getResultList();
            }
            return this.copyPlayersToDetails(players);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    @Override
    public List<PlayerDetails> getPlayersNotOnTeam() {
        logger.info("getPlayersNotOnTeam");
        List players = null;
        try {
            CriteriaQuery cq = this.cb.createQuery(Player.class);
            if (cq != null) {
                Root player = cq.from(Player.class);
                cq.where((Expression)this.cb.isEmpty(player.get(Player_.teams)));
                cq.select((Selection)player).distinct(true);
                TypedQuery q = this.em.createQuery(cq);
                players = q.getResultList();
            }
            return this.copyPlayersToDetails(players);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    @Override
    public List<PlayerDetails> getPlayersByPositionAndName(String position, String name) {
        logger.info("getPlayersByPositionAndName");
        List players = null;
        try {
            CriteriaQuery cq = this.cb.createQuery(Player.class);
            if (cq != null) {
                Root player = cq.from(Player.class);
                cq.where(new Predicate[]{this.cb.equal((Expression)player.get(Player_.position), (Object)position), this.cb.equal((Expression)player.get(Player_.name), (Object)name)});
                cq.select((Selection)player).distinct(true);
                TypedQuery q = this.em.createQuery(cq);
                players = q.getResultList();
            }
            return this.copyPlayersToDetails(players);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    @Override
    public List<LeagueDetails> getLeaguesOfPlayer(String playerId) {
        logger.info("getLeaguesOfPlayer");
        ArrayList<LeagueDetails> detailsList = new ArrayList<LeagueDetails>();
        List leagues = null;
        try {
            CriteriaQuery cq = this.cb.createQuery(League.class);
            if (cq != null) {
                Object league = cq.from(League.class);
                CollectionJoin team = league.join(League_.teams);
                CollectionJoin player = team.join(Team_.players);
                cq.where((Expression)this.cb.equal((Expression)player.get(Player_.id), (Object)playerId));
                cq.select((Selection)league).distinct(true);
                TypedQuery q = this.em.createQuery(cq);
                leagues = q.getResultList();
            }
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
        for (Object league : leagues) {
            LeagueDetails leagueDetails = new LeagueDetails(((League)league).getId(), ((League)league).getName(), ((League)league).getSport());
            detailsList.add(leagueDetails);
        }
        return detailsList;
    }

    @Override
    public List<String> getSportsOfPlayer(String playerId) {
        logger.info("getSportsOfPlayer");
        List<String> sports = new ArrayList<String>();
        try {
            CriteriaQuery cq = this.cb.createQuery(String.class);
            if (cq != null) {
                Root player = cq.from(Player.class);
                CollectionJoin team = player.join(Player_.teams);
                Join league = team.join(Team_.league);
                cq.where((Expression)this.cb.equal((Expression)player.get(Player_.id), (Object)playerId));
                cq.select((Selection)league.get(League_.sport)).distinct(true);
                TypedQuery q = this.em.createQuery(cq);
                sports = q.getResultList();
            }
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
        return sports;
    }

    @Override
    public void createTeamInLeague(TeamDetails teamDetails, String leagueId) {
        logger.info("createTeamInLeague");
        try {
            League league = (League)this.em.find(League.class, (Object)leagueId);
            Team team = new Team(teamDetails.getId(), teamDetails.getName(), teamDetails.getCity());
            this.em.persist((Object)team);
            team.setLeague(league);
            league.addTeam(team);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    @Override
    public void removeTeam(String teamId) {
        logger.info("removeTeam");
        try {
            Team team = (Team)this.em.find(Team.class, (Object)teamId);
            Collection<Player> players = team.getPlayers();
            for (Player player : players) {
                player.dropTeam(team);
            }
            this.em.remove((Object)team);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    @Override
    public TeamDetails getTeam(String teamId) {
        logger.info("getTeam");
        TeamDetails teamDetails = null;
        try {
            Team team = (Team)this.em.find(Team.class, (Object)teamId);
            teamDetails = new TeamDetails(team.getId(), team.getName(), team.getCity());
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
        return teamDetails;
    }

    @Override
    public void createLeague(LeagueDetails leagueDetails) {
        block4: {
            logger.info("createLeague");
            try {
                if (leagueDetails.getSport().equalsIgnoreCase("soccer") || leagueDetails.getSport().equalsIgnoreCase("swimming") || leagueDetails.getSport().equalsIgnoreCase("basketball") || leagueDetails.getSport().equalsIgnoreCase("baseball")) {
                    SummerLeague league = new SummerLeague(leagueDetails.getId(), leagueDetails.getName(), leagueDetails.getSport());
                    this.em.persist((Object)league);
                    break block4;
                }
                if (leagueDetails.getSport().equalsIgnoreCase("hockey") || leagueDetails.getSport().equalsIgnoreCase("skiing") || leagueDetails.getSport().equalsIgnoreCase("snowboarding")) {
                    WinterLeague league = new WinterLeague(leagueDetails.getId(), leagueDetails.getName(), leagueDetails.getSport());
                    this.em.persist((Object)league);
                    break block4;
                }
                throw new IncorrectSportException("The specified sport is not valid.");
            }
            catch (Exception ex) {
                throw new EJBException(ex);
            }
        }
    }

    @Override
    public void removeLeague(String leagueId) {
        logger.info("removeLeague");
        try {
            League league = (League)this.em.find(League.class, (Object)leagueId);
            this.em.remove((Object)league);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    @Override
    public LeagueDetails getLeague(String leagueId) {
        logger.info("getLeague");
        LeagueDetails leagueDetails = null;
        try {
            League league = (League)this.em.find(League.class, (Object)leagueId);
            leagueDetails = new LeagueDetails(league.getId(), league.getName(), league.getSport());
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
        return leagueDetails;
    }

    private List<PlayerDetails> copyPlayersToDetails(List<Player> players) {
        ArrayList<PlayerDetails> detailsList = new ArrayList<PlayerDetails>();
        for (Player player : players) {
            PlayerDetails playerDetails = new PlayerDetails(player.getId(), player.getName(), player.getPosition(), player.getSalary());
            detailsList.add(playerDetails);
        }
        return detailsList;
    }
}

