/*
 * Decompiled with CFR 0.152.
 */
package roster.client;

import java.util.List;
import javax.ejb.EJB;
import roster.request.Request;
import roster.util.LeagueDetails;
import roster.util.PlayerDetails;
import roster.util.TeamDetails;

public class RosterClient {
    @EJB
    private static Request request;

    public RosterClient(String[] args) {
    }

    public static void main(String[] args) {
        RosterClient client = new RosterClient(args);
        try {
            client.insertInfo();
            client.getSomeInfo();
            client.getMoreInfo();
            client.removeInfo();
            System.exit(0);
        }
        catch (Exception ex) {
            System.err.println("Caught an exception:");
            ex.printStackTrace();
        }
    }

    private void insertInfo() {
        try {
            request.createLeague(new LeagueDetails("L1", "Mountain", "Soccer"));
            request.createLeague(new LeagueDetails("L2", "Valley", "Basketball"));
            request.createLeague(new LeagueDetails("L3", "Foothills", "Soccer"));
            request.createLeague(new LeagueDetails("L4", "Alpine", "Snowboarding"));
            request.createTeamInLeague(new TeamDetails("T1", "Honey Bees", "Visalia"), "L1");
            request.createTeamInLeague(new TeamDetails("T2", "Gophers", "Manteca"), "L1");
            request.createTeamInLeague(new TeamDetails("T5", "Crows", "Orland"), "L1");
            request.createTeamInLeague(new TeamDetails("T3", "Deer", "Bodie"), "L2");
            request.createTeamInLeague(new TeamDetails("T4", "Trout", "Truckee"), "L2");
            request.createTeamInLeague(new TeamDetails("T6", "Marmots", "Auburn"), "L3");
            request.createTeamInLeague(new TeamDetails("T7", "Bobcats", "Grass Valley"), "L3");
            request.createTeamInLeague(new TeamDetails("T8", "Beavers", "Placerville"), "L3");
            request.createTeamInLeague(new TeamDetails("T9", "Penguins", "Incline Village"), "L4");
            request.createTeamInLeague(new TeamDetails("T10", "Land Otters", "Tahoe City"), "L4");
            request.createPlayer("P1", "Phil Jones", "goalkeeper", 100.0);
            request.addPlayer("P1", "T1");
            request.createPlayer("P2", "Alice Smith", "defender", 505.0);
            request.addPlayer("P2", "T1");
            request.createPlayer("P3", "Bob Roberts", "midfielder", 65.0);
            request.addPlayer("P3", "T1");
            request.createPlayer("P4", "Grace Phillips", "forward", 100.0);
            request.addPlayer("P4", "T1");
            request.createPlayer("P5", "Barney Bold", "defender", 100.0);
            request.addPlayer("P5", "T1");
            request.createPlayer("P6", "Ian Carlyle", "goalkeeper", 555.0);
            request.addPlayer("P6", "T2");
            request.createPlayer("P7", "Rebecca Struthers", "midfielder", 777.0);
            request.addPlayer("P7", "T2");
            request.createPlayer("P8", "Anne Anderson", "forward", 65.0);
            request.addPlayer("P8", "T2");
            request.createPlayer("P9", "Jan Wesley", "defender", 100.0);
            request.addPlayer("P9", "T2");
            request.createPlayer("P10", "Terry Smithson", "midfielder", 100.0);
            request.addPlayer("P10", "T2");
            request.createPlayer("P11", "Ben Shore", "point guard", 188.0);
            request.addPlayer("P11", "T3");
            request.createPlayer("P12", "Chris Farley", "shooting guard", 577.0);
            request.addPlayer("P12", "T3");
            request.createPlayer("P13", "Audrey Brown", "small forward", 995.0);
            request.addPlayer("P13", "T3");
            request.createPlayer("P14", "Jack Patterson", "power forward", 100.0);
            request.addPlayer("P14", "T3");
            request.createPlayer("P15", "Candace Lewis", "point guard", 100.0);
            request.addPlayer("P15", "T3");
            request.createPlayer("P16", "Linda Berringer", "point guard", 844.0);
            request.addPlayer("P16", "T4");
            request.createPlayer("P17", "Bertrand Morris", "shooting guard", 452.0);
            request.addPlayer("P17", "T4");
            request.createPlayer("P18", "Nancy White", "small forward", 833.0);
            request.addPlayer("P18", "T4");
            request.createPlayer("P19", "Billy Black", "power forward", 444.0);
            request.addPlayer("P19", "T4");
            request.createPlayer("P20", "Jodie James", "point guard", 100.0);
            request.addPlayer("P20", "T4");
            request.createPlayer("P21", "Henry Shute", "goalkeeper", 205.0);
            request.addPlayer("P21", "T5");
            request.createPlayer("P22", "Janice Walker", "defender", 857.0);
            request.addPlayer("P22", "T5");
            request.createPlayer("P23", "Wally Hendricks", "midfielder", 748.0);
            request.addPlayer("P23", "T5");
            request.createPlayer("P24", "Gloria Garber", "forward", 777.0);
            request.addPlayer("P24", "T5");
            request.createPlayer("P25", "Frank Fletcher", "defender", 399.0);
            request.addPlayer("P25", "T5");
            request.createPlayer("P30", "Lakshme Singh", "downhill", 450.0);
            request.addPlayer("P30", "T9");
            request.createPlayer("P31", "Mariela Prieto", "freestyle", 420.0);
            request.addPlayer("P31", "T9");
            request.createPlayer("P32", "Soren Johannsen", "freestyle", 375.0);
            request.addPlayer("P32", "T10");
            request.createPlayer("P33", "Andre Gerson", "freestyle", 396.0);
            request.addPlayer("P33", "T10");
            request.createPlayer("P34", "Zoria Lepsius", "downhill", 431.0);
            request.addPlayer("P34", "T10");
            request.createPlayer("P26", "Hobie Jackson", "pitcher", 582.0);
            request.createPlayer("P27", "Melinda Kendall", "catcher", 677.0);
            request.createPlayer("P28", "Constance Adams", "substitute", 966.0);
            request.addPlayer("P28", "T1");
            request.addPlayer("P28", "T3");
            request.addPlayer("P24", "T6");
            request.addPlayer("P21", "T6");
            request.addPlayer("P9", "T6");
            request.addPlayer("P7", "T5");
        }
        catch (Exception ex) {
            System.err.println("Caught an exception:");
            ex.printStackTrace();
        }
    }

    private void getSomeInfo() {
        try {
            System.out.println("List all players in team T2:");
            List playerList = request.getPlayersOfTeam("T2");
            RosterClient.printDetailsList(playerList);
            System.out.println();
            System.out.println("List all teams in league L1:");
            List teamList = request.getTeamsOfLeague("L1");
            RosterClient.printDetailsList(teamList);
            System.out.println();
            System.out.println("List all defenders:");
            playerList = request.getPlayersByPosition("defender");
            RosterClient.printDetailsList(playerList);
            System.out.println();
            System.out.println("List the leagues of player P28");
            List leagueList = request.getLeaguesOfPlayer("P28");
            RosterClient.printDetailsList(leagueList);
            System.out.println();
        }
        catch (Exception ex) {
            System.err.println("Caught an exception:");
            ex.printStackTrace();
        }
    }

    private void getMoreInfo() {
        try {
            System.out.println("Details of league L1:");
            LeagueDetails leagueDetails = request.getLeague("L1");
            System.out.println(leagueDetails.toString());
            System.out.println();
            System.out.println("Details of team T3:");
            TeamDetails teamDetails = request.getTeam("T3");
            System.out.println(teamDetails.toString());
            System.out.println();
            System.out.println("Details of player P20:");
            PlayerDetails playerDetails = request.getPlayer("P20");
            System.out.println(playerDetails.toString());
            System.out.println();
            System.out.println("List all teams in league L3:");
            List teamList = request.getTeamsOfLeague("L3");
            RosterClient.printDetailsList(teamList);
            System.out.println();
            System.out.println("List all players:");
            List playerList = request.getAllPlayers();
            RosterClient.printDetailsList(playerList);
            System.out.println();
            System.out.println("List all players not on a team:");
            playerList = request.getPlayersNotOnTeam();
            RosterClient.printDetailsList(playerList);
            System.out.println();
            System.out.println("Details of Jack Patterson, a power forward:");
            playerList = request.getPlayersByPositionAndName("power forward", "Jack Patterson");
            RosterClient.printDetailsList(playerList);
            System.out.println();
            System.out.println("List all players in the city of Truckee:");
            playerList = request.getPlayersByCity("Truckee");
            RosterClient.printDetailsList(playerList);
            System.out.println();
            System.out.println("List all soccer players:");
            playerList = request.getPlayersBySport("Soccer");
            RosterClient.printDetailsList(playerList);
            System.out.println();
            System.out.println("List all players in league L1:");
            playerList = request.getPlayersByLeagueId("L1");
            RosterClient.printDetailsList(playerList);
            System.out.println();
            System.out.println("List all players making a higher salary than Ian Carlyle:");
            playerList = request.getPlayersByHigherSalary("Ian Carlyle");
            RosterClient.printDetailsList(playerList);
            System.out.println();
            System.out.println("List all players with a salary between 500 and 800:");
            playerList = request.getPlayersBySalaryRange(500.0, 800.0);
            RosterClient.printDetailsList(playerList);
            System.out.println();
            System.out.println("List all players of team T5:");
            playerList = request.getPlayersOfTeam("T5");
            RosterClient.printDetailsList(playerList);
            System.out.println();
            System.out.println("List all the leagues of player P28:");
            List leagueList = request.getLeaguesOfPlayer("P28");
            RosterClient.printDetailsList(leagueList);
            System.out.println();
            System.out.println("List all the sports of player P28:");
            List sportList = request.getSportsOfPlayer("P28");
            RosterClient.printDetailsList(sportList);
            System.out.println();
        }
        catch (Exception ex) {
            System.err.println("Caught an exception:");
            ex.printStackTrace();
        }
    }

    private void removeInfo() {
        try {
            System.out.println("Removing team T6.");
            request.removeTeam("T6");
            System.out.println();
            System.out.println("Removing player P24");
            request.removePlayer("P24");
            System.out.println();
        }
        catch (Exception ex) {
            System.err.println("Caught an exception:");
            ex.printStackTrace();
        }
    }

    private static void printDetailsList(List list) {
        for (Object details : list) {
            System.out.println(details.toString());
        }
        System.out.println();
    }
}

