/*
 * Decompiled with CFR 0.152.
 */
package cart.ejb;

import cart.ejb.Cart;
import cart.util.BookException;
import cart.util.IdVerifier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Remove;
import javax.ejb.Stateful;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateful
@DeclareRoles(value={"TutorialUser"})
public class CartBean
implements Cart {
    List<String> contents;
    String customerId;
    String customerName;

    @Override
    public void initialize(String person) throws BookException {
        if (person == null) {
            throw new BookException("Niedozwolona osoba (person) o warto\u015bci null.");
        }
        this.customerName = person;
        this.customerId = "0";
        this.contents = new ArrayList<String>();
    }

    @Override
    public void initialize(String person, String id) throws BookException {
        if (person == null) {
            throw new BookException("Niedozwolona osoba (person) o warto\u015bci null.");
        }
        this.customerName = person;
        IdVerifier idChecker = new IdVerifier();
        if (!idChecker.validate(id)) {
            throw new BookException("Niepoprawne id: " + id);
        }
        this.customerId = id;
        this.contents = new ArrayList<String>();
    }

    @Override
    @RolesAllowed(value={"TutorialUser"})
    public void addBook(String title) {
        this.contents.add(title);
    }

    @Override
    @RolesAllowed(value={"TutorialUser"})
    public void removeBook(String title) throws BookException {
        boolean result = this.contents.remove(title);
        if (!result) {
            throw new BookException("\"" + title + "\" nie znajduje si\u0119 w koszyku.");
        }
    }

    @Override
    @RolesAllowed(value={"TutorialUser"})
    public List<String> getContents() {
        return this.contents;
    }

    @Override
    @Remove
    @RolesAllowed(value={"TutorialUser"})
    public void remove() {
        this.contents = null;
    }
}

