/*
 * Decompiled with CFR 0.152.
 */
package cart.ejb;

import cart.ejb.Cart;
import cart.util.BookException;
import cart.util.IdVerifier;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Remove;
import javax.ejb.Stateful;

@Stateful
public class CartBean
implements Cart {
    List<String> contents;
    String customerId;
    String customerName;

    @Override
    public void initialize(String person) throws BookException {
        if (person == null) {
            throw new BookException("Parametr person nie mo\u017ce przyjmowa\u0107 warto\u015bci null.");
        }
        this.customerName = person;
        this.customerId = "0";
        this.contents = new ArrayList<String>();
    }

    @Override
    public void initialize(String person, String id) throws BookException {
        if (person == null) {
            throw new BookException("Parametr person nie mo\u017ce przyjmowa\u0107 warto\u015bci null.");
        }
        this.customerName = person;
        IdVerifier idChecker = new IdVerifier();
        if (!idChecker.validate(id)) {
            throw new BookException("B\u0142\u0119dny identyfikator: " + id);
        }
        this.customerId = id;
        this.contents = new ArrayList<String>();
    }

    @Override
    public void addBook(String title) {
        this.contents.add(title);
    }

    @Override
    public void removeBook(String title) throws BookException {
        boolean result = this.contents.remove(title);
        if (!result) {
            throw new BookException("\"" + title + "\" nie znajduje si\u0119 w koszyku.");
        }
    }

    @Override
    public List<String> getContents() {
        return this.contents;
    }

    @Override
    @Remove
    public void remove() {
        this.contents = null;
    }
}

