import java.util.*;

public final class PhoneNumber {
    private final short areaCode;
    private final short prefix;
    private final short lineNumber;

    public PhoneNumber(int areaCode, int prefix,
                       int lineNumber) {
        rangeCheck(areaCode,   999, "nr kierunkowy");
        rangeCheck(prefix,   999, "prefiks");
        rangeCheck(lineNumber, 9999, "numer linii");
        this.areaCode  = (short) areaCode;
        this.prefix  = (short) prefix;
        this.lineNumber = (short) lineNumber;
    }

    private static void rangeCheck(int arg, int max,
                                   String name) {
        if (arg < 0 || arg > max)
           throw new IllegalArgumentException(name +": " + arg);
    }

    @Override public boolean equals(Object o) {
        if (o == this)
            return true;
        if (!(o instanceof PhoneNumber))
            return false;
        PhoneNumber pn = (PhoneNumber)o;
        return pn.lineNumber == lineNumber
            && pn.prefix  == prefix
            && pn.areaCode  == areaCode;
    }

    @Override public int hashCode() {
        int result = 17;
        result = 31 * result + areaCode;
        result = 31 * result + prefix;
        result = 31 * result + lineNumber;
        return result;
    }

    /**
     * Zwraca cig reprezentujcy ten numer telefonu.
     * Cig skada si z czternastu znakw w formacie
     * "(XXX) YYY-ZZZZ", gdzie XXX jest numerem kierunkowym, YYY to
     * centrala, a ZZZZ rozszerzenie (kada litera reprezentuje
     * jedn cyfr).
     *
     * Jeeli dowolna z tych trzech czci jest zbyt maa, 
     * aby wypeni swoje pole, jest ono uzupeniane z lewej strony zerami.
     * Na przykad, jeeli numerem linii jest 123, ostatnie 
     * cztery znaki cigu bd miay posta "0123".
     *
     * Za zamykajcym nawiasem znajduje si spacja, oddzielajca 
     * numer kierunkowy od prefiksu.
     */
    @Override public String toString() {
        return String.format("(%03d) %03d-%04d",
                             areaCode, prefix, lineNumber);
    }

    public static void main(String[] args) {
        Map<PhoneNumber, String> m
            = new HashMap<PhoneNumber, String>();
        m.put(new PhoneNumber(707, 867, 5309), "Jenny");
        System.out.println(m);
    }
}
