import java.io.*;

public final class StringList implements Serializable {
    private transient int size   = 0;
    private transient Entry head = null;

    private static class Entry {
        String data;
        Entry  next;
        Entry  previous;
    }

    public final void add(String s) {
    }

    /**
     * Serializacja tego obiektu {@code StringList}.
     *
     * @serialData Rozmiar przesyanej listy (ilo zawartych w niej cigw)
     * ({@code int}), po ktrym nastpuj wszystkie jej elementy
     * (kady to {@code String}), w odpowiedniej kolejnoci.
     */
    private void writeObject(ObjectOutputStream s)
            throws IOException {
        s.defaultWriteObject();
        s.writeInt(size);

        for (Entry e = head; e != null; e = e.next)
            s.writeObject(e.data);
    }

    private void readObject(ObjectInputStream s)
            throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numElements = s.readInt();

        for (int i = 0; i < numElements; i++)
            add((String) s.readObject());
    }

    private static final long serialVersionUID = 93248094385L;
}
