// Program P7.9

import java.io.*;
import java.util.*;
public class UseIndex {
   static final int StringFixedLength = 20;
   static final int PartNumSize = 6;
   static final int PartRecordSize = 64;
   static int MaxRecords;

   public static void main(String[] args) throws IOException {
      RandomAccessFile fp = new RandomAccessFile("parts.bin", "rw");
      Index[] index = retrieveIndex();
      int numRecords = index[0].recNum;
      Scanner kb = new Scanner(System.in);
      System.out.printf("\nPodaj numer czci (lub E, aby zakoczy): ");
      String pnum = kb.next();
      while (!pnum.equalsIgnoreCase("E")) {
         int n = search(pnum, index, numRecords);
         if (n > 0) {
            fp.seek(PartRecordSize * (index[n].recNum - 1));
            readPartFromFile(fp).printPart();
         }
         else System.out.printf("Nie udao si znale czci.\n");
         System.out.printf("\nPodaj numer czci (lub E, aby zakoczy): ");
         pnum = kb.next();
      } //koniec while
      fp.close();
   } //koniec main

   public static Index[] retrieveIndex() throws IOException {
      RandomAccessFile f = new RandomAccessFile("index.bin", "rw");
      int MaxRecords = f.readInt();
      Index[] index = new Index[MaxRecords + 1];
      for (int j = 0; j <= MaxRecords; j++) {
         String pnum = "";
         for (int i = 0; i < PartNumSize; i++) pnum += f.readChar();
         index[j] = new Index(pnum, f.readInt());
      }
      f.close();
      return index;
   } //koniec retrieveIndex

   public static Part readPartFromFile(RandomAccessFile f) throws IOException {
      String pname = "";
      for (int h = 0; h < PartNumSize; h++) pname += f.readChar();
      char[] name = new char[StringFixedLength];
      for (int h = 0; h < StringFixedLength; h++) name[h] = f.readChar();
      String hold = new String(name, 0, StringFixedLength);
      return new Part(pname, hold.trim(), f.readInt(), f.readDouble());
   } //koniec readPartFromFile

   public static int search(String key, Index[] list, int n) {
   //funkcja przeglda tablic list[1..n] w poszukiwaniu klucza; jeli go 
   //znajdzie, to zwraca jego lokalizacj; w przeciwnym razie zwraca ujemn 
   //warto okrelajc miejsce gdzie dany klucz powinien zosta wstawiony.
      int lo = 1, hi = n;
      while (lo <= hi) {   // dopki s jakie elementy do sprawdzenia
         int mid = (lo + hi) / 2;
         int cmp = key.compareToIgnoreCase(list[mid].partNum);
         if (cmp == 0) return mid;  // udao si znale klucz
         if (cmp < 0) hi = mid - 1;   // klucz jest 'mniejszy' od list[mid].partNum
         else lo = mid + 1;     // klucz jest 'wikszy' od list[mid].partNum
      }
      return -lo;         // nie zaleziono klucza; naley go wstawi w miejscu lo
   } //koniec search

} //koniec class UseIndex

class Part {
   String partNum, name;
   int amtInStock;
   double price;

   public Part(String pn, String n, int a, double p) {
      partNum = pn;
      name = n;
      amtInStock = a;
      price = p;
   }

   public void printPart() {
      System.out.printf("Numer czci: %s\n", partNum);
      System.out.printf("Nazwa czci: %s\n", name);
      System.out.printf("Liczba dostpnych czci: %d\n", amtInStock);
      System.out.printf("Cena: %3.2f z\n", price);
   }

} //koniec class Part

class Index {
   String partNum;
   int recNum;

   public Index(String p, int r) {
      partNum = p;
      recNum = r;
   }
} //koniec class Index
