// Program P7.5

import java.io.*;
import java.util.*;
public class CreateBinaryFile2 {
   static final int EndOfData = 0;

   public static void main(String[] args) throws IOException {
      Scanner in = new Scanner(new FileReader("parts.txt"));
      DataOutputStream fp =
               new DataOutputStream(new FileOutputStream("parts.bin"));

      Part part = getPartData(in);
      while (part != null) {
         writePartToFile(part, fp);
         part = getPartData(in);
      }

      in.close();
      fp.close();
   } //koniec main

   public static Part getPartData(Scanner in) {
      int pnum = in.nextInt();
      if (pnum == EndOfData) return null;
      return new Part(pnum, in.nextDouble());
   }

   public static void writePartToFile(Part part, DataOutputStream f) throws IOException {
      f.writeInt(part.partNum);
      f.writeDouble(part.price);
      part.printPart(); //wywietlenie danych w standardowym strumieniu wyjciowym
   } //koniec writePartToFile
} //koniec klasy CreateBinaryFile2

class Part {
   int partNum;
   double price;

   public Part(int pn, double pr) {
      partNum = pn;
      price = pr;
   }

   public void printPart() {
      System.out.printf("\nNumer czci: %s\n", partNum);
      System.out.printf("Cena: %3.2f z\n", price);
   }
} //koniec klasy Part
