//Program P2.5

import java.util.*;
import java.io.*;
public class Voting {
   final static int MaxCandidates = 7;
   public static void main(String[] args) throws IOException {
      Scanner in = new Scanner(new FileReader("votes.txt"));
      PrintWriter out = new PrintWriter(new FileWriter("results.txt"));
      Person[] candidate = new Person[MaxCandidates+1];
      //ptla pobiera personalia i ustawia wyniki na 0
      for (int h = 1; h <= MaxCandidates; h++)
         candidate[h] = new Person(in.nextLine(), 0);
      VoteCount count = processVotes(candidate, MaxCandidates, in, out);
      printResults(out, candidate, MaxCandidates, count);
      in.close();
      out.close();
   } //koniec main

   public static VoteCount processVotes(Person[] list, int max, Scanner in, PrintWriter out) {
      VoteCount votes = new VoteCount(0, 0); //liczby wanych, niewaynyc gosw ustawiamy na 0
      int v = in.nextInt();
      while (v != 0) {
         if (v < 1 || v > max) {
            out.printf("Niewany gos: %d\n", v);
            ++votes.spoilt;
         }
         else {
            ++list[v].numVotes;
            ++votes.valid;
         }
         v = in.nextInt();
      } //koniec while
      return votes;
   } //koniec processVotes

   public static void printResults(PrintWriter out, Person[] list,
                        int max, VoteCount votes) {
      out.printf("\nLiczba gosujcych: %d\n", votes.valid + votes.spoilt);
      out.printf("Liczba prawidowych gosw: %d\n", votes.valid);
      out.printf("Liczba nieprawidowych gosw: %d\n", votes.spoilt);
      out.printf("\nKandydat          Gosw\n\n");
      for (int h = 1; h <= MaxCandidates; h++)
         out.printf("%-18s %3d\n", list[h].name, list[h].numVotes);
      out.printf("\nZwycizca (zwycizcy):\n");
      int win = getLargest(list, 1, MaxCandidates);
      int winningVote = list[win].numVotes;
      for (int h = 1; h <= MaxCandidates; h++)
         if (list[h].numVotes == winningVote) out.printf("   %s\n", list[h].name);
   } //koniec printResults

   public static int getLargest(Person[] list, int lo, int hi) {
      int big = lo;
      for (int h = lo + 1; h <= hi; h++)
         if (list[h].numVotes > list[big].numVotes) big = h;
      return big;
   } //koniec getLargest
} //koniec klasy Voting

class Person {
   String name;
   int numVotes;
   Person(String s, int n) {
      name = s;
      numVotes = n;
   }
} //koniec klasy Person

class VoteCount {
   int valid, spoilt;
   VoteCount(int v, int s) {
      valid = v;
      spoilt = s;
   }
} //koniec klasy VoteCount
