import java.awt.*;
import java.io.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import java.util.*;
import javax.comm.*;

public class SimpleComm extends JxFrame  
implements ListSelectionListener {
    CommPortIdentifier portId;
    Enumeration portEnum;
    Vector ports;

    JawtList status;
    JList portList;
    JScrollPane psw;
    int lastIndex;

    public SimpleComm() {

        super ("Comm Singleton");
        JPanel jp = new JPanel();
        getContentPane().add(jp);
        jp.setLayout (new BorderLayout());

        ports = new Vector();
        portList = new JList(ports);
        psw = new JScrollPane();
        psw.setBorder(new BevelBorder(BevelBorder.LOWERED));
        psw.getViewport().setView (portList);
        jp.add("West", psw);
        portList.addListSelectionListener (this);
        lastIndex = -1;       //index of last selected com port

        //now add status list on right
        status =  new JawtList(20);
        jp.add("Center", status);

        loadPorts();    //load into list box
        setSize(new Dimension(300,200));
        setVisible(true);


    }
    //------------------------------------
    public void valueChanged(ListSelectionEvent ls) {

        int index = portList.getSelectedIndex();
        if (index != lastIndex) {
            lastIndex = index;      //debounces mouse unclick
            //get port name back from list box
            String portName = (String)ports.elementAt (index);
            try {
                //try to get port ownership
                portId = CommPortIdentifier.getPortIdentifier(portName);

                //if successful, open the port
                CommPort cp = portId.open("SimpleComm",100);
                //report success
                status.add("Port opened: "+portName);
            }
            catch (NoSuchPortException e) {
                status.add("No such port: "+portName);
            }
            catch (PortInUseException e) {
                status.add (portName+" in use by: "+portId.getCurrentOwner());
            }
        }
    }
    //------------------------------------
    private void loadPorts() {
        portEnum = CommPortIdentifier.getPortIdentifiers();

        while (portEnum.hasMoreElements()) {
            portId = (CommPortIdentifier) portEnum.nextElement();
            if (portId.getPortType() == CommPortIdentifier.PORT_SERIAL) {
                ports.addElement (portId.getName());
            }
        }
        //add bogus port
        ports.addElement("COM5");
        psw.doLayout ();
        psw.validate();
    }
    //------------------------------------
    public static void main(String[] args) {
        new SimpleComm();
    }

}
