package com.visualpatterns.timex.model;

import java.util.Date;
import java.util.List;

import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Session;
import com.visualpatterns.timex.util.HibernateUtil;

/**
 * Zarzadza operacjami dla tabeli Timesheet.
 * @author anil
 */
public class TimesheetManager
{
    /**
     * Zwraca rekordy dla okreslonego 
     * employeeId.
     */
    public List getTimesheets(int employeeId)
    {
        List timesheetList = null;

        Session session = HibernateUtil.getSessionFactory()
                .getCurrentSession();
        session.beginTransaction();
        try
        {
            timesheetList = session.createQuery(
                    "from Timesheet" + " where employeeId = ?").setInteger(0,
                    employeeId).list();
            session.getTransaction().commit();
        }
        catch (HibernateException e)
        {
            session.getTransaction().rollback();
            throw e;
        }

        return timesheetList;
    }

    /**
     * Zwraca rekordy Timesheet na podstawie employeeId i
     * periodEndingDate.
     */
    public Timesheet getTimesheet(int employeeId, Date periodEndingDate)
    {
        Timesheet timesheet = null;

        Session session = HibernateUtil.getSessionFactory()
                .getCurrentSession();
        session.beginTransaction();
        try
        {
            timesheet = (Timesheet) session.createQuery(
                    "from Timesheet" + " where employeeId = ?"
                            + " and periodEndingDate = ?").setInteger(0,
                    employeeId).setDate(1, periodEndingDate).uniqueResult();
            session.getTransaction().commit();
        }
        catch (HibernateException e)
        {
            session.getTransaction().rollback();
            throw e;
        }

        return timesheet;
    }

    /**
     * Zapisuje obiekt Timesheet.
     */
    public void saveTimesheet(Timesheet timesheet)
    {
        Session session = HibernateUtil.getSessionFactory()
                .getCurrentSession();
        session.beginTransaction();
        try
        {
            session.saveOrUpdate(timesheet);
            session.getTransaction().commit();
        }
        catch (HibernateException e)
        {
            session.getTransaction().rollback();
            throw e;
        }
    }

    /**
     * Zwraca rekordy posortowane wg timesheetId
     */
    public List getTimesheets()
    {
        List timesheetList = null;
        Session session = HibernateUtil.getSessionFactory()
                .getCurrentSession();
        session.beginTransaction();
        try
        {
            timesheetList = session.createQuery(
                    "from Timesheet ORDER BY timesheetId").list();
            session.getTransaction().commit();
        }
        catch (HibernateException e)
        {
            session.getTransaction().rollback();
            throw e;
        }

        return timesheetList;
    }

    /**
     * Usuwa rekorfy Timesheet dla okeslonego timeSheetId 
     */
    public void deleteTimesheet(int timesheetId)
    {
        Session session = HibernateUtil.getSessionFactory()
                .getCurrentSession();
        session.beginTransaction();
        try
        {
            session.delete(session.load(Timesheet.class, new Integer(
                    timesheetId)));
            session.flush();
            session.getTransaction().commit();
        }
        catch (HibernateException e)
        {
            session.getTransaction().rollback();
            throw e;
        }
    }

    /**
     * Zwraca rekordy dla okreslonego timesheetId
     * i demonstruje jak reokdy moga byc blokowane z uzyciem Hibernate.
     */
    public Timesheet getTimesheet(int timesheetId, boolean doLock)
    {
        Session session = HibernateUtil.getSessionFactory()
                .getCurrentSession();
        session.beginTransaction();
        Timesheet timesheet = null;
        try
        {
            if (doLock)
                timesheet = (Timesheet) session.get(Timesheet.class,
                        new Integer(timesheetId), LockMode.UPGRADE);
            else
                timesheet = (Timesheet) session.get(Timesheet.class,
                        new Integer(timesheetId));
            session.getTransaction().commit();
        }
        catch (HibernateException e)
        {
            session.getTransaction().rollback();
            throw e;
        }

        return timesheet;
    }
}
