package com.visualpatterns.timex.controller;

import org.springframework.validation.Errors;
import com.visualpatterns.timex.model.Timesheet;

/**
 * Walidator dla EnterHoursController
 * @author anil
 * @see com.visualpatterns.timex.controller.EnterHoursController
 */
public class EnterHoursValidator implements
        org.springframework.validation.Validator
{
    public boolean supports(Class clazz)
    {
        return clazz.equals(Timesheet.class);
    }

    /**
     * Sprawdza poprawnosc obiektu Timesheet command.  Upewnij sie ze 
     * departmentCode jest okreslony.
     * @see Timesheet 
     */
    public void validate(Object command, Errors errors)
    {
        Timesheet timesheet = (Timesheet) command;
        if (timesheet == null) return;

        if (timesheet.getDepartmentCode() == null
                || timesheet.getDepartmentCode().trim().length() < 1)
            errors.reject("error.enterhours.missingdepartment");
    }
}
