/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import org.springframework.core.CollectionFactory;
import org.springframework.util.Assert;

public class MockPortletPreferences
implements PortletPreferences {
    private PreferencesValidator preferencesValidator;
    private final Map preferences = CollectionFactory.createLinkedMapIfPossible((int)16);
    private final Map readOnly = new HashMap();

    public boolean isReadOnly(String key) {
        Assert.notNull((Object)key);
        return this.readOnly.containsKey(key);
    }

    public String getValue(String key, String def) {
        Assert.notNull((Object)key);
        String[] values = (String[])this.preferences.get(key);
        return values != null && values.length > 0 ? values[0] : def;
    }

    public String[] getValues(String key, String[] def) {
        Assert.notNull((Object)key);
        String[] values = (String[])this.preferences.get(key);
        return values != null && values.length > 0 ? values : def;
    }

    public void setValue(String key, String value) throws ReadOnlyException {
        Assert.notNull((Object)key);
        if (this.isReadOnly(key)) {
            throw new ReadOnlyException("preference '" + key + "' is read-only");
        }
        this.preferences.put(key, new String[]{value});
    }

    public void setValues(String key, String[] values) throws ReadOnlyException {
        Assert.notNull((Object)key);
        if (this.isReadOnly(key)) {
            throw new ReadOnlyException("Preference '" + key + "' is read-only");
        }
        this.preferences.put(key, values);
    }

    public Enumeration getNames() {
        return Collections.enumeration(this.preferences.keySet());
    }

    public Map getMap() {
        return Collections.unmodifiableMap(this.preferences);
    }

    public void reset(String key) throws ReadOnlyException {
        Assert.notNull((Object)key);
        this.preferences.remove(key);
    }

    public void store() throws IOException, ValidatorException {
        if (this.preferencesValidator != null) {
            this.preferencesValidator.validate((PortletPreferences)this);
        }
    }

    public void setPreferencesValidator(PreferencesValidator preferencesValidator) {
        this.preferencesValidator = preferencesValidator;
    }

    public void setReadOnly(String key, boolean readOnly) {
        Assert.notNull((Object)key);
        if (readOnly) {
            this.readOnly.put(key, null);
        } else {
            this.readOnly.remove(key);
        }
    }
}

