/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.support;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;

public class SharedEntityManagerAdapter
implements FactoryBean {
    private EntityManager entityManager;

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.entityManager = (EntityManager)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{EntityManager.class}, (InvocationHandler)new SharedEntityManagerInvocationHandler(emf));
    }

    public Object getObject() {
        return this.entityManager;
    }

    public Class getObjectType() {
        return EntityManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private static class SharedEntityManagerInvocationHandler
    implements InvocationHandler {
        private final EntityManagerFactory targetFactory;

        public SharedEntityManagerInvocationHandler(EntityManagerFactory target) {
            this.targetFactory = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("isOpen")) {
                return Boolean.TRUE;
            }
            if (method.getName().equals("close")) {
                return null;
            }
            if (method.getName().equals("getTransaction")) {
                throw new IllegalStateException("Not allowed to create transaction on shared EntityManager - use Spring transactions or EJB CMT instead");
            }
            EntityManager target = null;
            boolean isNewEm = false;
            try {
                target = EntityManagerFactoryUtils.getEntityManager(this.targetFactory);
            }
            catch (IllegalStateException ex) {
                target = this.targetFactory.createEntityManager();
                isNewEm = true;
            }
            try {
                Object ex = method.invoke((Object)target, args);
                return ex;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
            finally {
                if (isNewEm) {
                    target.close();
                }
            }
        }
    }
}

