/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.support;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DaoSupport;
import org.springframework.orm.jpa.JpaTemplate;

public abstract class JpaDaoSupport
extends DaoSupport {
    private JpaTemplate jpaTemplate;

    public final void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.jpaTemplate = this.createJpaTemplate(entityManagerFactory);
    }

    protected JpaTemplate createJpaTemplate(EntityManagerFactory entityManagerFactory) {
        return new JpaTemplate(entityManagerFactory);
    }

    public final void setEntityManager(EntityManagerFactory entityManager) {
        this.jpaTemplate = this.createJpaTemplate(entityManager);
    }

    protected JpaTemplate createJpaTemplate(EntityManager entityManager) {
        return new JpaTemplate(entityManager);
    }

    public final EntityManagerFactory getEntityManagerFactory() {
        return this.jpaTemplate != null ? this.jpaTemplate.getEntityManagerFactory() : null;
    }

    public final EntityManager getEntityManager() {
        return this.jpaTemplate != null ? this.jpaTemplate.getEntityManager() : null;
    }

    public final void setJpaTemplate(JpaTemplate jpaTemplate) {
        this.jpaTemplate = jpaTemplate;
    }

    public final JpaTemplate getJpaTemplate() {
        return this.jpaTemplate;
    }

    protected final void checkDaoConfig() {
        if (this.jpaTemplate == null) {
            throw new IllegalArgumentException("entityManagerFactory or jpaTemplate is required");
        }
    }

    protected final DataAccessException convertJpaAccessException(PersistenceException ex) {
        return this.jpaTemplate.convertJpaAccessException(ex);
    }
}

