/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.util.ClassUtils;

public class LocalEntityManagerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private EntityManagerFactory targetEntityManagerFactory;
    private Class persistenceProviderClass;
    private String entityManagerName;
    private EntityManagerFactory entityManagerFactory;
    private Properties jpaProperties;
    private boolean exposeTransactionAwareEntityManagerFactory = true;

    public void setTargetEntityManagerFactory(EntityManagerFactory targetEntityManagerFactory) {
        this.targetEntityManagerFactory = targetEntityManagerFactory;
    }

    public void setPersistenceProviderClass(Class persistenceProviderClass) {
        if (persistenceProviderClass != null && !PersistenceProvider.class.isAssignableFrom(persistenceProviderClass)) {
            throw new IllegalArgumentException("serviceFactoryClass must implement [javax.persistence.spi.PersistenceProvider]");
        }
        this.persistenceProviderClass = persistenceProviderClass;
    }

    public void setEntityManagerName(String entityManagerName) {
        this.entityManagerName = entityManagerName;
    }

    public void setJpaProperties(Properties jpaProperties) {
        this.jpaProperties = jpaProperties;
    }

    public void setExposeTransactionAwareEntityManagerFactory(boolean exposeTransactionAwareEntityManagerFactory) {
        this.exposeTransactionAwareEntityManagerFactory = exposeTransactionAwareEntityManagerFactory;
    }

    public final void afterPropertiesSet() throws PersistenceException {
        EntityManagerFactory emf = null;
        if (this.targetEntityManagerFactory != null) {
            emf = this.targetEntityManagerFactory;
        } else if (this.persistenceProviderClass != null) {
            PersistenceProvider pp = (PersistenceProvider)BeanUtils.instantiateClass(this.persistenceProviderClass);
            emf = pp.createEntityManagerFactory(this.entityManagerName, (Map)this.jpaProperties);
            if (emf == null) {
                throw new IllegalStateException("PersistenceProvider [" + this.persistenceProviderClass.getName() + "] did not return an EntityManagerFactory for name '" + this.entityManagerName + "'");
            }
        } else {
            emf = Persistence.createEntityManagerFactory((String)this.entityManagerName, (Map)this.jpaProperties);
        }
        this.entityManagerFactory = this.exposeTransactionAwareEntityManagerFactory ? this.getTransactionAwareEntityManagerFactory(emf) : emf;
    }

    protected EntityManagerFactory getTransactionAwareEntityManagerFactory(EntityManagerFactory target) {
        Class[] ifcs = ClassUtils.getAllInterfaces(target);
        return (EntityManagerFactory)Proxy.newProxyInstance(this.getClass().getClassLoader(), ifcs, (InvocationHandler)new TransactionAwareInvocationHandler(target));
    }

    public Object getObject() {
        return this.entityManagerFactory;
    }

    public Class getObjectType() {
        return this.entityManagerFactory != null ? this.entityManagerFactory.getClass() : EntityManagerFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.logger.info((Object)"Closing JPA EntityManagerFactory");
        this.entityManagerFactory.close();
    }

    private static class TransactionAwareInvocationHandler
    implements InvocationHandler {
        private final EntityManagerFactory target;

        public TransactionAwareInvocationHandler(EntityManagerFactory target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getEntityManager")) {
                try {
                    return EntityManagerFactoryUtils.doGetEntityManager((EntityManagerFactory)proxy);
                }
                catch (IllegalStateException springEx) {
                    try {
                        return this.target.getEntityManager();
                    }
                    catch (IllegalStateException jpaEx) {
                        throw new IllegalStateException("Could not obtain transactional EntityManager: neither from Spring [" + springEx.getMessage() + "] nor from JPA provider [" + jpaEx.getMessage() + "]");
                    }
                }
            }
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

