/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.orm.jpa.JpaAccessor;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JpaInterceptor
extends JpaAccessor
implements MethodInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        EntityManager em = null;
        boolean isNewEm = false;
        try {
            try {
                em = EntityManagerFactoryUtils.getEntityManager(this.getEntityManagerFactory());
            }
            catch (IllegalStateException ex) {
                this.logger.debug((Object)"Creating new EntityManager for JPA interceptor");
                em = this.getEntityManagerFactory().createEntityManager();
                isNewEm = true;
                TransactionSynchronizationManager.bindResource(this.getEntityManagerFactory(), new EntityManagerHolder(em));
            }
        }
        catch (PersistenceException ex) {
            throw new DataAccessResourceFailureException("Could not open JPA EntityManager", ex);
        }
        try {
            Object retVal = methodInvocation.proceed();
            this.flushIfNecessary(em, !isNewEm);
            Object object = retVal;
            return object;
        }
        finally {
            if (isNewEm) {
                TransactionSynchronizationManager.unbindResource(this.getEntityManagerFactory());
                this.logger.debug((Object)"Closing new EntityManager for JPA interceptor");
                em.close();
            }
        }
    }
}

