/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.LazyInitTargetSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.jmx.export.MBeanExportException;
import org.springframework.jmx.export.MBeanExportOperations;
import org.springframework.jmx.export.MBeanExporterListener;
import org.springframework.jmx.export.NotificationListenerBean;
import org.springframework.jmx.export.SpringModelMBean;
import org.springframework.jmx.export.UnableToRegisterMBeanException;
import org.springframework.jmx.export.assembler.AutodetectCapableMBeanInfoAssembler;
import org.springframework.jmx.export.assembler.MBeanInfoAssembler;
import org.springframework.jmx.export.assembler.SimpleReflectiveMBeanInfoAssembler;
import org.springframework.jmx.export.naming.KeyNamingStrategy;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.springframework.jmx.export.naming.SelfNaming;
import org.springframework.jmx.export.notification.ModelMBeanNotificationPublisher;
import org.springframework.jmx.export.notification.NotificationPublisherAware;
import org.springframework.jmx.support.JmxUtils;
import org.springframework.jmx.support.MBeanRegistrationSupport;
import org.springframework.util.ObjectUtils;

public class MBeanExporter
extends MBeanRegistrationSupport
implements InitializingBean,
DisposableBean,
MBeanExportOperations,
BeanFactoryAware {
    private static final String MR_TYPE_OBJECT_REFERENCE = "ObjectReference";
    private static final String WILDCARD = "*";
    private Map beans;
    private boolean autodetect = false;
    private boolean ensureUniqueRuntimeObjectNames = true;
    private boolean exposeManagedResourceClassLoader = false;
    private String[] excludedBeans = new String[0];
    private MBeanExporterListener[] listeners;
    private NotificationListenerBean[] notificationListeners = new NotificationListenerBean[0];
    private MBeanInfoAssembler assembler = new SimpleReflectiveMBeanInfoAssembler();
    private ObjectNamingStrategy namingStrategy = new KeyNamingStrategy();
    private ListableBeanFactory beanFactory;

    public void setBeans(Map beans) {
        this.beans = beans;
    }

    public void setAutodetect(boolean autodetect) {
        this.autodetect = autodetect;
    }

    public void setAssembler(MBeanInfoAssembler assembler) {
        this.assembler = assembler;
    }

    public void setNamingStrategy(ObjectNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ListableBeanFactory) {
            this.beanFactory = (ListableBeanFactory)beanFactory;
        } else {
            this.logger.info((Object)"Not running in a ListableBeanFactory: autodetection of MBeans not available");
        }
    }

    public void setListeners(MBeanExporterListener[] listeners) {
        this.listeners = listeners;
    }

    public void setExcludedBeans(String[] excludedBeans) {
        this.excludedBeans = excludedBeans != null ? excludedBeans : new String[]{};
    }

    public void setEnsureUniqueRuntimeObjectNames(boolean ensureUniqueRuntimeObjectNames) {
        this.ensureUniqueRuntimeObjectNames = ensureUniqueRuntimeObjectNames;
    }

    public void setExposeManagedResourceClassLoader(boolean exposeManagedResourceClassLoader) {
        this.exposeManagedResourceClassLoader = exposeManagedResourceClassLoader;
    }

    public void setNotificationListeners(NotificationListenerBean[] notificationListeners) {
        this.notificationListeners = notificationListeners;
    }

    public void setNotificationListenerMappings(Map listeners) throws MalformedObjectNameException {
        ArrayList<NotificationListenerBean> notificationListeners = new ArrayList<NotificationListenerBean>();
        Iterator iterator = listeners.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object value = entry.getValue();
            if (!(value instanceof NotificationListener)) {
                throw new IllegalArgumentException("Map entry value [" + value + "] is not a valid NotificationListener");
            }
            Object key = entry.getKey();
            ObjectName mappedObjectName = null;
            if (!WILDCARD.equals(key)) {
                mappedObjectName = JmxUtils.convertToObjectName(entry.getKey());
            }
            NotificationListenerBean bean = new NotificationListenerBean((NotificationListener)value);
            if (mappedObjectName != null) {
                bean.setMappedObjectName(mappedObjectName);
            }
            notificationListeners.add(bean);
        }
        this.notificationListeners = notificationListeners.toArray(new NotificationListenerBean[notificationListeners.size()]);
    }

    public void afterPropertiesSet() {
        this.logger.info((Object)"Registering beans for JMX exposure on startup");
        this.registerBeans();
    }

    public void destroy() {
        this.logger.info((Object)"Unregistering JMX-exposed beans on shutdown");
        this.unregisterBeans();
    }

    public ObjectName registerManagedResource(Object managedResource) throws MBeanExportException {
        try {
            ObjectName objectName = this.getObjectName(managedResource, null);
            if (this.ensureUniqueRuntimeObjectNames) {
                objectName = JmxUtils.appendIdentityToObjectName(objectName, managedResource);
            }
            this.registerManagedResource(managedResource, objectName);
            return objectName;
        }
        catch (MalformedObjectNameException ex) {
            throw new MBeanExportException("Unable to generate ObjectName for MBean [" + managedResource + "]", ex);
        }
    }

    public void registerManagedResource(Object managedResource, ObjectName objectName) throws MBeanExportException {
        ModelMBean mbean = this.createAndConfigureMBean(managedResource, managedResource.getClass().getName());
        try {
            this.doRegister(mbean, objectName);
        }
        catch (JMException ex) {
            throw new UnableToRegisterMBeanException("Unable to register MBean [" + managedResource + "] with object name [" + objectName + "]", ex);
        }
    }

    protected void registerBeans() {
        if (this.server == null) {
            this.server = JmxUtils.locateMBeanServer();
        }
        if (this.beans == null) {
            this.beans = new HashMap();
        }
        if (this.autodetect) {
            if (this.beanFactory == null) {
                throw new MBeanExportException("Cannot autodetect MBeans if not running in a BeanFactory");
            }
            this.logger.info((Object)"Autodetecting user-defined JMX MBeans");
            this.autodetectMBeans();
            if (this.assembler instanceof AutodetectCapableMBeanInfoAssembler) {
                this.autodetectBeans((AutodetectCapableMBeanInfoAssembler)this.assembler);
            }
        }
        if (this.beans.isEmpty()) {
            throw new IllegalArgumentException("Must specify at least one bean for registration");
        }
        try {
            Iterator it = this.beans.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String beanKey = (String)entry.getKey();
                Object value = entry.getValue();
                this.registerBeanNameOrInstance(value, beanKey);
            }
            this.registerNotificationListeners();
        }
        catch (MBeanExportException ex) {
            this.unregisterBeans();
            throw ex;
        }
    }

    protected boolean isBeanDefinitionLazyInit(ListableBeanFactory beanFactory, String beanName) {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            return false;
        }
        try {
            BeanDefinition bd = ((ConfigurableListableBeanFactory)beanFactory).getBeanDefinition(beanName);
            return bd.isLazyInit();
        }
        catch (NoSuchBeanDefinitionException ex) {
            return false;
        }
    }

    protected ObjectName registerBeanNameOrInstance(Object mapValue, String beanKey) throws MBeanExportException {
        try {
            if (mapValue instanceof String) {
                if (this.beanFactory == null) {
                    throw new MBeanExportException("Cannot resolve bean names if not running in a BeanFactory");
                }
                String beanName = (String)mapValue;
                if (this.isBeanDefinitionLazyInit(this.beanFactory, beanName)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Found bean name for lazy init bean with key [" + beanKey + "]. Registering bean with lazy init support."));
                    }
                    return this.registerLazyInit(beanName, beanKey);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("String value under key [" + beanKey + "] points to a bean that was not " + "registered for lazy initialization. Registering bean normally with JMX server."));
                }
                Object bean = this.beanFactory.getBean(beanName);
                return this.registerBeanInstance(bean, beanKey);
            }
            return this.registerBeanInstance(mapValue, beanKey);
        }
        catch (JMException ex) {
            throw new UnableToRegisterMBeanException("Unable to register MBean [" + mapValue + "] with key [" + beanKey + "]", ex);
        }
    }

    private ObjectName registerBeanInstance(Object bean, String beanKey) throws JMException {
        if (JmxUtils.isMBean(bean.getClass())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Located MBean under key [" + beanKey + "]: registering with JMX server"));
            }
            return this.registerMBean(bean, beanKey);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Located simple bean under key [" + beanKey + "]: registering with JMX server"));
        }
        return this.registerSimpleBean(bean, beanKey);
    }

    private ObjectName registerMBean(Object mbean, String beanKey) throws JMException {
        ObjectName objectName = this.getObjectName(mbean, beanKey);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registering MBean [" + objectName + "]"));
        }
        this.doRegister(mbean, objectName);
        return objectName;
    }

    private ObjectName registerSimpleBean(Object bean, String beanKey) throws JMException {
        ObjectName objectName = this.getObjectName(bean, beanKey);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registering and assembling MBean [" + objectName + "]"));
        }
        ModelMBean mbean = this.createAndConfigureMBean(bean, beanKey);
        this.doRegister(mbean, objectName);
        this.injectNotificationPublisherIfNecessary(bean, mbean);
        return objectName;
    }

    private ObjectName registerLazyInit(String beanName, String beanKey) throws JMException {
        NotificationPublisherAwareLazyTargetSource targetSource = new NotificationPublisherAwareLazyTargetSource();
        targetSource.setTargetBeanName(beanName);
        targetSource.setBeanFactory(this.beanFactory);
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetSource(targetSource);
        proxyFactory.setProxyTargetClass(true);
        proxyFactory.setFrozen(true);
        Object proxy = proxyFactory.getProxy();
        ObjectName objectName = this.getObjectName(proxy, beanKey);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registering lazy-init MBean [" + objectName + "]"));
        }
        ModelMBean mbean = this.createAndConfigureMBean(proxy, beanKey);
        targetSource.setModelMBean(mbean);
        this.doRegister(mbean, objectName);
        return objectName;
    }

    protected ObjectName getObjectName(Object bean, String beanKey) throws MalformedObjectNameException {
        if (bean instanceof SelfNaming) {
            return ((SelfNaming)bean).getObjectName();
        }
        return this.namingStrategy.getObjectName(bean, beanKey);
    }

    protected ModelMBean createAndConfigureMBean(Object managedResource, String beanKey) throws MBeanExportException {
        try {
            ModelMBean mbean = this.createModelMBean();
            mbean.setModelMBeanInfo(this.getMBeanInfo(managedResource, beanKey));
            mbean.setManagedResource(managedResource, MR_TYPE_OBJECT_REFERENCE);
            return mbean;
        }
        catch (Exception ex) {
            throw new MBeanExportException("Could not create ModelMBean for managed resource [" + managedResource + "] with key [" + beanKey + "]", ex);
        }
    }

    protected ModelMBean createModelMBean() throws MBeanException {
        return this.exposeManagedResourceClassLoader ? new SpringModelMBean() : new RequiredModelMBean();
    }

    private ModelMBeanInfo getMBeanInfo(Object managedBean, String beanKey) throws JMException {
        ModelMBeanInfo info = this.assembler.getMBeanInfo(managedBean, beanKey);
        if (this.logger.isWarnEnabled() && ObjectUtils.isEmpty(info.getAttributes()) && ObjectUtils.isEmpty(info.getOperations())) {
            this.logger.warn((Object)("Bean with key [" + beanKey + "] has been registed as an MBean but has no exposed attributes or operations"));
        }
        return info;
    }

    private void autodetectBeans(final AutodetectCapableMBeanInfoAssembler assembler) {
        this.autodetect(new AutodetectCallback(){

            public boolean include(Class beanClass, String beanName) {
                return assembler.includeBean(beanClass, beanName);
            }
        });
    }

    private void autodetectMBeans() {
        this.autodetect(new AutodetectCallback(){

            public boolean include(Class beanClass, String beanName) {
                return JmxUtils.isMBean(beanClass);
            }
        });
    }

    private void autodetect(AutodetectCallback callback) {
        String[] beanNames = this.beanFactory.getBeanNamesForType(null);
        for (int i = 0; i < beanNames.length; ++i) {
            Object beanInstance;
            Class beanClass;
            String beanName = beanNames[i];
            if (this.isExcluded(beanName) || (beanClass = this.beanFactory.getType(beanName)) == null || !callback.include(beanClass, beanName)) continue;
            boolean lazyInit = this.isBeanDefinitionLazyInit(this.beanFactory, beanName);
            Object object = beanInstance = !lazyInit ? this.beanFactory.getBean(beanName) : null;
            if (!(this.beans.containsValue(beanName) || beanInstance != null && this.beans.containsValue(beanInstance))) {
                this.beans.put(beanName, beanInstance != null ? beanInstance : beanName);
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info((Object)("Bean with name '" + beanName + "' has been autodetected for JMX exposure"));
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Bean with name '" + beanName + "' is already registered for JMX exposure"));
        }
    }

    private boolean isExcluded(String beanName) {
        return Arrays.binarySearch(this.excludedBeans, beanName) > -1;
    }

    private void injectNotificationPublisherIfNecessary(Object managedResource, ModelMBean modelMBean) {
        if (managedResource instanceof NotificationPublisherAware) {
            ((NotificationPublisherAware)managedResource).setNotificationPublisher(new ModelMBeanNotificationPublisher(modelMBean));
        }
    }

    private void registerNotificationListeners() {
        for (int i = 0; i < this.notificationListeners.length; ++i) {
            NotificationListenerBean bean = this.notificationListeners[i];
            NotificationListener listener = bean.getNotificationListener();
            NotificationFilter filter = bean.getNotificationFilter();
            Object handback = bean.getHandback();
            ObjectName[] namesToRegisterWith = this.getObjectNamesForNotificationListener(bean);
            for (int j = 0; j < namesToRegisterWith.length; ++j) {
                ObjectName objectName = namesToRegisterWith[j];
                try {
                    this.server.addNotificationListener(objectName, listener, filter, handback);
                    continue;
                }
                catch (InstanceNotFoundException ex) {
                    throw new MBeanExportException("Unable to register NotificationListener for MBean [" + objectName + "] because that MBean instance does not exist", ex);
                }
            }
        }
    }

    private ObjectName[] getObjectNamesForNotificationListener(NotificationListenerBean bean) {
        ObjectName[] mappedObjectNames = bean.getMappedObjectNames();
        if (mappedObjectNames == null) {
            return this.registeredBeans.toArray(new ObjectName[this.registeredBeans.size()]);
        }
        return mappedObjectNames;
    }

    protected void onRegister(ObjectName objectName) {
        this.notifyListenersOfRegistration(objectName);
    }

    protected void onUnregister(ObjectName objectName) {
        this.notifyListenersOfUnregistration(objectName);
    }

    private void notifyListenersOfRegistration(ObjectName objectName) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].mbeanRegistered(objectName);
            }
        }
    }

    private void notifyListenersOfUnregistration(ObjectName objectName) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].mbeanUnregistered(objectName);
            }
        }
    }

    private class NotificationPublisherAwareLazyTargetSource
    extends LazyInitTargetSource {
        private ModelMBean modelMBean;

        private NotificationPublisherAwareLazyTargetSource() {
        }

        public void setModelMBean(ModelMBean modelMBean) {
            this.modelMBean = modelMBean;
        }

        protected void postProcessTargetObject(Object targetObject) {
            MBeanExporter.this.injectNotificationPublisherIfNecessary(targetObject, this.modelMBean);
        }
    }

    private static interface AutodetectCallback {
        public boolean include(Class var1, String var2);
    }
}

