/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.springframework.beans.Mergable;
import org.springframework.core.CollectionFactory;

public class ManagedSet
implements Set,
Mergable {
    private Set targetSet;
    private boolean mergeEnabled;

    public ManagedSet() {
        this(16);
    }

    public ManagedSet(int initialCapacity) {
        this.targetSet = CollectionFactory.createLinkedSetIfPossible(initialCapacity);
    }

    public ManagedSet(Set targetSet) {
        this.targetSet = targetSet;
    }

    public void setMergeEnabled(boolean mergeEnabled) {
        this.mergeEnabled = mergeEnabled;
    }

    public boolean isMergeEnabled() {
        return this.mergeEnabled;
    }

    public void merge(Object other) {
        if (other instanceof Set) {
            Set otherSet = (Set)other;
            Set temp = CollectionFactory.createLinkedSetIfPossible(otherSet.size() + this.size());
            temp.addAll(otherSet);
            temp.addAll(this);
            this.targetSet = temp;
        }
    }

    public int size() {
        return this.targetSet.size();
    }

    public boolean isEmpty() {
        return this.targetSet.isEmpty();
    }

    public boolean contains(Object obj) {
        return this.targetSet.contains(obj);
    }

    public Iterator iterator() {
        return this.targetSet.iterator();
    }

    public Object[] toArray() {
        return this.targetSet.toArray();
    }

    public Object[] toArray(Object[] arr) {
        return this.targetSet.toArray(arr);
    }

    public boolean add(Object obj) {
        return this.targetSet.add(obj);
    }

    public boolean remove(Object obj) {
        return this.targetSet.remove(obj);
    }

    public boolean containsAll(Collection coll) {
        return this.targetSet.containsAll(coll);
    }

    public boolean addAll(Collection coll) {
        return this.targetSet.addAll(coll);
    }

    public boolean retainAll(Collection coll) {
        return this.targetSet.retainAll(coll);
    }

    public boolean removeAll(Collection coll) {
        return this.targetSet.removeAll(coll);
    }

    public void clear() {
        this.targetSet.clear();
    }

    public int hashCode() {
        return ((Object)this.targetSet).hashCode();
    }

    public boolean equals(Object obj) {
        return ((Object)this.targetSet).equals(obj);
    }

    public String toString() {
        return this.targetSet.toString();
    }
}

