/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.Mergable;
import org.springframework.core.CollectionFactory;

public class ManagedMap
implements Map,
Mergable {
    private Map targetMap;
    private boolean mergeEnabled;

    public ManagedMap() {
        this(16);
    }

    public ManagedMap(int initialCapacity) {
        this.targetMap = CollectionFactory.createLinkedMapIfPossible(initialCapacity);
    }

    public ManagedMap(Map targetMap) {
        this.targetMap = targetMap;
    }

    public void setMergeEnabled(boolean mergeEnabled) {
        this.mergeEnabled = mergeEnabled;
    }

    public boolean isMergeEnabled() {
        return this.mergeEnabled;
    }

    public void merge(Object parent) {
        if (parent instanceof Map) {
            Map parentMap = (Map)parent;
            Map temp = CollectionFactory.createLinkedMapIfPossible(parentMap.size() + this.size());
            temp.putAll(parentMap);
            temp.putAll(this);
            this.targetMap = temp;
        }
    }

    public int size() {
        return this.targetMap.size();
    }

    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.targetMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.targetMap.containsValue(value);
    }

    public Object get(Object key) {
        return this.targetMap.get(key);
    }

    public Object put(Object key, Object value) {
        return this.targetMap.put(key, value);
    }

    public Object remove(Object key) {
        return this.targetMap.remove(key);
    }

    public void putAll(Map t) {
        this.targetMap.putAll(t);
    }

    public void clear() {
        this.targetMap.clear();
    }

    public Set keySet() {
        return this.targetMap.keySet();
    }

    public Collection values() {
        return this.targetMap.values();
    }

    public Set entrySet() {
        return this.targetMap.entrySet();
    }

    public int hashCode() {
        return ((Object)this.targetMap).hashCode();
    }

    public boolean equals(Object obj) {
        return ((Object)this.targetMap).equals(obj);
    }

    public String toString() {
        return this.targetMap.toString();
    }
}

