/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target.dynamic;

import org.springframework.aop.target.dynamic.AbstractRefreshableTargetSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class BeanFactoryRefreshableTargetSource
extends AbstractRefreshableTargetSource {
    private String beanName;
    private DefaultListableBeanFactory childFactory;

    public BeanFactoryRefreshableTargetSource(BeanFactory factory, String beanName, DefaultListableBeanFactory childFactory) {
        this.beanName = beanName;
        this.childFactory = childFactory == null ? new DefaultListableBeanFactory(factory) : childFactory;
        ChildBeanDefinition definition = this.createChildBeanDefinition(beanName);
        definition.setSingleton(false);
        this.childFactory.registerBeanDefinition(beanName, definition);
    }

    protected Object freshTarget() {
        return this.childFactory.getBean(this.beanName);
    }

    protected ChildBeanDefinition createChildBeanDefinition(String beanName) {
        return new ChildBeanDefinition(beanName, null);
    }
}

