/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import java.io.Serializable;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;

public abstract class AbstractTraceInterceptor
implements MethodInterceptor,
Serializable {
    protected transient Log defaultLogger = LogFactory.getLog(this.getClass());
    private boolean hideProxyClassNames = false;

    public void setUseDynamicLogger(boolean useDynamicLogger) {
        this.defaultLogger = useDynamicLogger ? null : LogFactory.getLog(this.getClass());
    }

    public void setLoggerName(String loggerName) {
        this.defaultLogger = LogFactory.getLog((String)loggerName);
    }

    public void setHideProxyClassNames(boolean hideProxyClassNames) {
        this.hideProxyClassNames = hideProxyClassNames;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Log logger = this.getLoggerForInvocation(invocation);
        if (logger.isTraceEnabled()) {
            return this.invokeUnderTrace(invocation, logger);
        }
        return invocation.proceed();
    }

    protected Log getLoggerForInvocation(MethodInvocation invocation) {
        if (this.defaultLogger != null) {
            return this.defaultLogger;
        }
        Object target = invocation.getThis();
        Class logCategoryClass = target.getClass();
        if (this.hideProxyClassNames) {
            if (AopUtils.isJdkDynamicProxy(target) && target instanceof Advised) {
                Class targetClass = ((Advised)target).getTargetSource().getTargetClass();
                if (targetClass != null) {
                    logCategoryClass = targetClass;
                }
            } else {
                while (AopUtils.isCglibProxyClass(logCategoryClass)) {
                    logCategoryClass = logCategoryClass.getSuperclass();
                }
            }
        }
        return LogFactory.getLog(logCategoryClass);
    }

    protected abstract Object invokeUnderTrace(MethodInvocation var1, Log var2) throws Throwable;
}

