/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.annotation;

import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aspectj.lang.reflect.PerClauseKind;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.aspectj.InstantiationModelAwarePointcutAdvisor;
import org.springframework.aop.aspectj.annotation.AspectJAdvisorFactory;
import org.springframework.aop.aspectj.annotation.AspectMetadata;
import org.springframework.aop.aspectj.annotation.MetadataAwareAspectInstanceFactory;
import org.springframework.aop.support.DynamicMethodMatcherPointcut;
import org.springframework.aop.support.Pointcuts;

class InstantiationModelAwarePointcutAdvisorImpl
implements InstantiationModelAwarePointcutAdvisor {
    private final AspectJExpressionPointcut declaredPointcut;
    private Pointcut pointcut;
    private final MetadataAwareAspectInstanceFactory aif;
    private final Method method;
    private final boolean lazy;
    private final AspectJAdvisorFactory atAspectJAdvisorFactory;
    private Advice instantiatedAdvice;

    public InstantiationModelAwarePointcutAdvisorImpl(AspectJAdvisorFactory af, AspectJExpressionPointcut ajexp, MetadataAwareAspectInstanceFactory aif, Method method) {
        this.declaredPointcut = ajexp;
        this.method = method;
        this.atAspectJAdvisorFactory = af;
        this.aif = aif;
        if (aif.getAspectMetadata().isPerThisOrPerTarget()) {
            Pointcut preInstantiationORPointcut = Pointcuts.union(aif.getAspectMetadata().getPerClausePointcut(), this.declaredPointcut);
            this.pointcut = new PerTargetInstantiationModelPointcut(this.declaredPointcut, preInstantiationORPointcut, aif);
            this.lazy = true;
        } else {
            this.instantiatedAdvice = this.instantiateAdvice();
            this.pointcut = this.declaredPointcut;
            this.lazy = false;
        }
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public boolean isPerInstance() {
        return this.getAspectMetadata().getAjType().getPerClause().getKind() != PerClauseKind.SINGLETON;
    }

    public AspectMetadata getAspectMetadata() {
        return this.aif.getAspectMetadata();
    }

    public synchronized Advice getAdvice() {
        if (this.instantiatedAdvice == null) {
            this.instantiatedAdvice = this.instantiateAdvice();
        }
        return this.instantiatedAdvice;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public synchronized boolean isAdviceInstantiated() {
        return this.instantiatedAdvice != null;
    }

    private Advice instantiateAdvice() {
        return this.atAspectJAdvisorFactory.getAdvice(this.method, this.aif);
    }

    public MetadataAwareAspectInstanceFactory getAspectInstanceFactory() {
        return this.aif;
    }

    public AspectJExpressionPointcut getDeclaredPointcut() {
        return this.declaredPointcut;
    }

    public String toString() {
        return "InstantiationModelAwarePointcutAdvisor: expr='" + this.getDeclaredPointcut().getExpression() + "' advice method=" + this.method + "; perClauseKind=" + this.aif.getAspectMetadata().getAjType().getPerClause().getKind() + "; instantiationCount=" + this.aif.getInstantiationCount();
    }

    private class PerTargetInstantiationModelPointcut
    extends DynamicMethodMatcherPointcut {
        private final AspectJExpressionPointcut declaredPointcut;
        private final Pointcut preInstantiationORPointcut;
        private final MetadataAwareAspectInstanceFactory aif;

        private PerTargetInstantiationModelPointcut(AspectJExpressionPointcut declaredPointcut, Pointcut preInstantiationORPointcut, MetadataAwareAspectInstanceFactory aif) {
            this.declaredPointcut = declaredPointcut;
            this.preInstantiationORPointcut = preInstantiationORPointcut;
            this.aif = aif;
        }

        public boolean matches(Method method, Class targetClass) {
            return this.aif.getInstantiationCount() > 0 && this.declaredPointcut.matches(method, targetClass) || this.preInstantiationORPointcut.getMethodMatcher().matches(method, targetClass);
        }

        public boolean matches(Method method, Class targetClass, Object[] args) {
            return this.aif.getInstantiationCount() > 0 && this.declaredPointcut.matches(method, targetClass);
        }
    }
}

