/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.AjTypeSystem;
import org.aspectj.lang.reflect.PerClauseKind;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.aspectj.annotation.AspectJAdvisorFactory;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.beans.support.annotation.AnnotationUtils;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.PrioritizedParameterNameDiscoverer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAspectJAdvisorFactory
implements AspectJAdvisorFactory {
    protected static final ParameterNameDiscoverer ASPECTJ_ANNOTATION_PARAMETER_NAME_DISCOVERER = new ParameterNameDiscoverer(){

        public String[] getParameterNames(Constructor ctor) {
            throw new UnsupportedOperationException("Spring AOP cannot handle constructor advice");
        }

        public String[] getParameterNames(Method m, Class clazz) {
            AspectJAnnotation annotation = AbstractAspectJAdvisorFactory.findAspectJAnnotationOnMethod(m, clazz);
            if (annotation == null) {
                return null;
            }
            StringTokenizer strTok = new StringTokenizer(annotation.getArgNames(), ",");
            String[] ret = new String[strTok.countTokens()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = strTok.nextToken();
            }
            return ret;
        }
    };
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final ParameterNameDiscoverer parameterNameDiscoverer;

    protected static AspectJAnnotation findAspectJAnnotationOnMethod(Method aMethod, Class clazz) {
        Class[] classesToLookFor;
        for (Class c : classesToLookFor = new Class[]{Before.class, Around.class, After.class, AfterReturning.class, AfterThrowing.class, Pointcut.class}) {
            AspectJAnnotation foundAnnotation = AbstractAspectJAdvisorFactory.findAnnotation(c, aMethod, clazz);
            if (foundAnnotation == null) continue;
            return foundAnnotation;
        }
        return null;
    }

    private static <A extends Annotation> AspectJAnnotation<A> findAnnotation(Class<A> toLookFor, Method method, Class clazz) {
        A result = AnnotationUtils.findMethodAnnotation(toLookFor, method, clazz);
        if (result != null) {
            return new AspectJAnnotation<A>(result);
        }
        return null;
    }

    protected AbstractAspectJAdvisorFactory() {
        PrioritizedParameterNameDiscoverer prioritizedParameterNameDiscoverer = new PrioritizedParameterNameDiscoverer();
        prioritizedParameterNameDiscoverer.addDiscoverer(ASPECTJ_ANNOTATION_PARAMETER_NAME_DISCOVERER);
        this.parameterNameDiscoverer = prioritizedParameterNameDiscoverer;
    }

    @Override
    public boolean isAspect(Class<?> clazz) {
        return AjTypeSystem.getAjType(clazz).isAspect();
    }

    @Override
    public void validate(Class<?> aspectClass) throws AopConfigException {
        if (aspectClass.getSuperclass().getAnnotation(Aspect.class) != null && !Modifier.isAbstract(aspectClass.getSuperclass().getModifiers())) {
            throw new AopConfigException(aspectClass.getName() + " cannot extend concrete aspect " + aspectClass.getSuperclass().getName());
        }
        AjType ajType = AjTypeSystem.getAjType(aspectClass);
        if (!ajType.isAspect()) {
            throw new IllegalStateException("Cannot validate " + aspectClass.getName() + ": not an aspect");
        }
        if (ajType.getPerClause().getKind() == PerClauseKind.PERCFLOW) {
            throw new AopConfigException(aspectClass.getName() + " uses percflow instantiation model: " + "This is not supported in Spring AOP");
        }
        if (ajType.getPerClause().getKind() == PerClauseKind.PERCFLOWBELOW) {
            throw new AopConfigException(aspectClass.getName() + " uses percflowbelow instantiation model: " + "This is not supported in Spring AOP");
        }
    }

    protected AspectJExpressionPointcut createPointcutExpression(Method annotatedMethod, Class declarationScope, String[] pointcutParameterNames) {
        Class[] pointcutParameterTypes = new Class[]{};
        if (pointcutParameterNames != null) {
            pointcutParameterTypes = this.extractPointcutParameterTypes(pointcutParameterNames, annotatedMethod);
        }
        AspectJExpressionPointcut ajexp = new AspectJExpressionPointcut(declarationScope, pointcutParameterNames, pointcutParameterTypes);
        ajexp.setLocation(annotatedMethod.toString());
        return ajexp;
    }

    private Class<?>[] extractPointcutParameterTypes(String[] argNames, Method adviceMethod) {
        Class[] ret = new Class[argNames.length];
        Class<?>[] paramTypes = adviceMethod.getParameterTypes();
        if (argNames.length > paramTypes.length) {
            throw new IllegalStateException("Expecting at least " + argNames.length + " arguments in the advice declaration, but only found " + paramTypes.length);
        }
        int typeOffset = paramTypes.length - argNames.length;
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = paramTypes[i + typeOffset];
        }
        return ret;
    }

    protected final class DelegatingIntroductionAdvisor
    implements IntroductionAdvisor {
        private final Class[] interfaces;
        private final ClassFilter filter;
        private final Advice advice;

        public DelegatingIntroductionAdvisor(Class[] interfaces, ClassFilter filter, Object instance) {
            this.interfaces = interfaces;
            this.filter = filter;
            this.advice = new DelegatingIntroductionInterceptor(instance);
        }

        public ClassFilter getClassFilter() {
            return this.filter;
        }

        public void validateInterfaces() throws IllegalArgumentException {
        }

        public boolean isPerInstance() {
            return true;
        }

        public Advice getAdvice() {
            return this.advice;
        }

        public Class[] getInterfaces() {
            return this.interfaces;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AspectJAnnotation<A extends Annotation> {
        private static Map<Class, AspectJAnnotationType> annotationTypes = new HashMap<Class, AspectJAnnotationType>();
        private final A annotation;
        private AspectJAnnotationType annotationType;
        private final String expression;
        private final String argNames;

        public AspectJAnnotation(A aspectjAnnotation) {
            this.annotation = aspectjAnnotation;
            for (Class c : annotationTypes.keySet()) {
                if (!c.isInstance(this.annotation)) continue;
                this.annotationType = annotationTypes.get(c);
                break;
            }
            if (this.annotationType == null) {
                throw new IllegalStateException("unknown annotation type: " + this.annotation.toString());
            }
            try {
                this.expression = (String)this.annotation.getClass().getMethod("value", null).invoke(this.annotation, new Object[0]);
                this.argNames = (String)this.annotation.getClass().getMethod("argNames", null).invoke(this.annotation, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(aspectjAnnotation + " cannot be an AspectJ annotation", ex);
            }
        }

        public AspectJAnnotationType getAnnotationType() {
            return this.annotationType;
        }

        public A getAnnotation() {
            return this.annotation;
        }

        public String getPointcutExpression() {
            return this.expression;
        }

        public String getArgNames() {
            return this.argNames;
        }

        public String toString() {
            return this.annotation.toString();
        }

        static {
            annotationTypes.put(Pointcut.class, AspectJAnnotationType.AtPointcut);
            annotationTypes.put(After.class, AspectJAnnotationType.AtAfter);
            annotationTypes.put(AfterReturning.class, AspectJAnnotationType.AtAfterReturning);
            annotationTypes.put(AfterThrowing.class, AspectJAnnotationType.AtAfterThrowing);
            annotationTypes.put(Around.class, AspectJAnnotationType.AtAround);
            annotationTypes.put(Before.class, AspectJAnnotationType.AtBefore);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum AspectJAnnotationType {
        AtPointcut,
        AtBefore,
        AtAfter,
        AtAfterReturning,
        AtAfterThrowing,
        AtAround;

    }
}

