/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.springframework.core.CollectionFactory;
import org.springframework.util.Assert;

public class MockPortletURL
implements PortletURL {
    private static final String ENCODING = "UTF-8";
    private final String urlType;
    private WindowState windowState;
    private PortletMode portletMode;
    private final Map parameters = CollectionFactory.createLinkedMapIfPossible((int)16);
    private boolean secure = false;

    public MockPortletURL(String urlType) {
        this.urlType = urlType;
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        this.windowState = windowState;
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        this.portletMode = portletMode;
    }

    public void setParameter(String name, String value) {
        Assert.notNull((Object)name);
        Assert.notNull((Object)value);
        this.parameters.put(name, new String[]{value});
    }

    public void setParameter(String name, String[] values) {
        Assert.notNull((Object)name);
        Assert.notNull((Object)values);
        this.parameters.put(name, values);
    }

    public void setParameters(Map parameters) {
        Map.Entry entry;
        Assert.notNull((Object)parameters);
        Iterator it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            Assert.notNull(entry.getKey());
            Assert.notNull(entry.getValue());
        }
        this.parameters.clear();
        it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            this.parameters.put(entry.getKey(), entry.getValue());
        }
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
        this.secure = secure;
    }

    public String toString() {
        StringBuffer query = new StringBuffer();
        query.append(this.encodeParameter("urlType", this.urlType));
        if (this.windowState != null) {
            query.append(";" + this.encodeParameter("windowState", this.windowState.toString()));
        }
        if (this.portletMode != null) {
            query.append(";" + this.encodeParameter("portletMode", this.portletMode.toString()));
        }
        Iterator it = this.parameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            query.append(";" + this.encodeParameter("param_" + name, values));
        }
        return (this.secure ? "https:" : "http:") + "//localhost/mockportlet?" + query.toString();
    }

    private String encodeParameter(String name, String value) {
        try {
            return URLEncoder.encode(name, ENCODING) + "=" + URLEncoder.encode(value, ENCODING);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String encodeParameter(String name, String[] values) {
        try {
            StringBuffer buf = new StringBuffer();
            int n = values.length;
            for (int i = 0; i < n; ++i) {
                buf.append((i > 0 ? ";" : "") + URLEncoder.encode(name, ENCODING) + "=" + URLEncoder.encode(values[i], ENCODING));
            }
            return buf.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

