/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.portlet.PortletResponse;
import org.springframework.util.Assert;

public class MockPortletResponse
implements PortletResponse {
    private final Hashtable properties = new Hashtable();

    public void addProperty(String key, String value) {
        Assert.notNull((Object)key, (String)"key must not be null");
        Object oldValue = this.properties.get(key);
        if (oldValue instanceof String) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(oldValue);
            list.add(value);
            this.properties.put(key, list);
        } else if (oldValue instanceof List) {
            ((List)oldValue).add(value);
        } else {
            this.properties.put(key, value);
        }
    }

    public void setProperty(String key, String value) {
        Assert.notNull((Object)key, (String)"key must not be null");
        this.properties.put(key, value);
    }

    public String encodeURL(String path) {
        return path;
    }

    public String getProperty(String key) {
        Assert.notNull((Object)key, (String)"key must not be null");
        Object value = this.properties.get(key);
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() < 1) {
                return null;
            }
            Object element = list.get(0);
            return element != null ? element.toString() : null;
        }
        return value != null ? value.toString() : null;
    }

    public Enumeration getProperties(String key) {
        Assert.notNull((Object)key, (String)"key must not be null");
        Object value = this.properties.get(key);
        if (value instanceof List) {
            return Collections.enumeration((List)value);
        }
        if (value != null) {
            Vector<String> vector = new Vector<String>(1);
            vector.add(value.toString());
            return vector.elements();
        }
        return Collections.enumeration(Collections.EMPTY_SET);
    }

    public Enumeration getPropertyNames() {
        return this.properties.keys();
    }
}

