/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import org.springframework.util.Assert;

public class MockPortletConfig
implements PortletConfig {
    private final PortletContext portletContext;
    private final String name;
    private final HashMap resourceBundles = new HashMap();
    private final Hashtable initParameters = new Hashtable();

    public MockPortletConfig(PortletContext portletContext) {
        this(portletContext, "");
    }

    public MockPortletConfig(PortletContext portletContext, String name) {
        this.portletContext = portletContext;
        this.name = name;
    }

    public String getPortletName() {
        return this.name;
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        Assert.notNull((Object)locale, (String)"locale may not be null");
        return (ResourceBundle)this.resourceBundles.get(locale);
    }

    public String getInitParameter(String name) {
        Assert.notNull((Object)name, (String)"name may not be null");
        return (String)this.initParameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        return this.initParameters.keys();
    }

    public void setResourceBundle(Locale locale, ResourceBundle resourceBundle) {
        Assert.notNull((Object)locale, (String)"locale may not be null");
        this.resourceBundles.put(locale, resourceBundle);
    }

    public void addInitParameter(String name, String value) {
        Assert.notNull((Object)name, (String)"name may not be null");
        this.initParameters.put(name, value);
    }
}

