/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.springframework.core.CollectionFactory;
import org.springframework.mock.web.portlet.MockPortletResponse;
import org.springframework.util.Assert;

public class MockActionResponse
extends MockPortletResponse
implements ActionResponse {
    private WindowState windowState;
    private PortletMode portletMode;
    private String redirectedUrl;
    private final Map renderParameters = CollectionFactory.createLinkedMapIfPossible((int)16);

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (this.redirectedUrl != null) {
            throw new IllegalStateException("Cannot  set windowState after sendRedirect has been called");
        }
        this.windowState = windowState;
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (this.redirectedUrl != null) {
            throw new IllegalStateException("Cannot  set portletMode after sendRedirect has been called");
        }
        this.portletMode = portletMode;
    }

    public void sendRedirect(String location) throws IOException {
        block3: {
            if (this.windowState != null || this.portletMode != null || !this.renderParameters.isEmpty()) {
                throw new IllegalStateException("Cannot call sendRedirect after windowState, portletMode, or renderParameters have been set");
            }
            Assert.notNull((Object)location);
            try {
                new URL(location);
            }
            catch (MalformedURLException ex) {
                if (location.startsWith("/")) break block3;
                throw new IllegalArgumentException("redirect URL must be valid and absolute");
            }
        }
        this.redirectedUrl = location;
    }

    public void setRenderParameters(Map parameters) {
        Map.Entry entry;
        if (this.redirectedUrl != null) {
            throw new IllegalStateException("Cannot set renderParameters after sendRedirect has been called");
        }
        Assert.notNull((Object)parameters);
        Iterator it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            Assert.notNull(entry.getKey());
            Assert.notNull(entry.getValue());
        }
        this.renderParameters.clear();
        it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            this.renderParameters.put(entry.getKey(), entry.getValue());
        }
    }

    public void setRenderParameter(String key, String value) {
        if (this.redirectedUrl != null) {
            throw new IllegalStateException("Cannot set renderParameters after sendRedirect has been called");
        }
        Assert.notNull((Object)key);
        Assert.notNull((Object)value);
        this.renderParameters.put(key, new String[]{value});
    }

    public void setRenderParameter(String key, String[] values) {
        if (this.redirectedUrl != null) {
            throw new IllegalStateException("Cannot set renderParameters after sendRedirect has been called");
        }
        Assert.notNull((Object)key);
        Assert.notNull((Object)values);
        this.renderParameters.put(key, values);
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    public PortletMode getPortletMode() {
        return this.portletMode;
    }

    public String getRedirectedUrl() {
        return this.redirectedUrl;
    }

    public String getRenderParameter(String name) {
        String[] arr = (String[])this.renderParameters.get(name);
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public String[] getRenderParameterValues(String name) {
        return (String[])this.renderParameters.get(name);
    }

    public Enumeration getRenderParameterNames() {
        return Collections.enumeration(this.renderParameters.keySet());
    }

    public Map getRenderParameterMap() {
        return Collections.unmodifiableMap(this.renderParameters);
    }
}

